/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceCollectionHealthRequest extends DevOpsGuruRequest implements
        ToCopyableBuilder<DescribeResourceCollectionHealthRequest.Builder, DescribeResourceCollectionHealthRequest> {
    private static final SdkField<String> RESOURCE_COLLECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceCollectionType")
            .getter(getter(DescribeResourceCollectionHealthRequest::resourceCollectionTypeAsString))
            .setter(setter(Builder::resourceCollectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceCollectionType").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeResourceCollectionHealthRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_COLLECTION_TYPE_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceCollectionType;

    private final String nextToken;

    private DescribeResourceCollectionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.resourceCollectionType = builder.resourceCollectionType;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
     * are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceCollectionType} will return {@link ResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceCollectionTypeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
     *         resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
     *         Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
     *         Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined
     *         in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web
     *         Services CloudFormation stacks.
     * @see ResourceCollectionType
     */
    public final ResourceCollectionType resourceCollectionType() {
        return ResourceCollectionType.fromValue(resourceCollectionType);
    }

    /**
     * <p>
     * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
     * are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceCollectionType} will return {@link ResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #resourceCollectionTypeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
     *         resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
     *         Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
     *         Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined
     *         in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web
     *         Services CloudFormation stacks.
     * @see ResourceCollectionType
     */
    public final String resourceCollectionTypeAsString() {
        return resourceCollectionType;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceCollectionHealthRequest)) {
            return false;
        }
        DescribeResourceCollectionHealthRequest other = (DescribeResourceCollectionHealthRequest) obj;
        return Objects.equals(resourceCollectionTypeAsString(), other.resourceCollectionTypeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourceCollectionHealthRequest")
                .add("ResourceCollectionType", resourceCollectionTypeAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceCollectionType":
            return Optional.ofNullable(clazz.cast(resourceCollectionTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceCollectionType", RESOURCE_COLLECTION_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceCollectionHealthRequest, T> g) {
        return obj -> g.apply((DescribeResourceCollectionHealthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourceCollectionHealthRequest> {
        /**
         * <p>
         * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         * resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
         * Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services
         * tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the
         * stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services
         * CloudFormation stacks.
         * </p>
         * 
         * @param resourceCollectionType
         *        An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         *        resources are defined. The two types of Amazon Web Services resource collections supported are Amazon
         *        Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
         *        Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are
         *        defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500
         *        Amazon Web Services CloudFormation stacks.
         * @see ResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCollectionType
         */
        Builder resourceCollectionType(String resourceCollectionType);

        /**
         * <p>
         * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         * resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
         * Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services
         * tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the
         * stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services
         * CloudFormation stacks.
         * </p>
         * 
         * @param resourceCollectionType
         *        An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         *        resources are defined. The two types of Amazon Web Services resource collections supported are Amazon
         *        Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
         *        Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are
         *        defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500
         *        Amazon Web Services CloudFormation stacks.
         * @see ResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceCollectionType
         */
        Builder resourceCollectionType(ResourceCollectionType resourceCollectionType);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private String resourceCollectionType;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceCollectionHealthRequest model) {
            super(model);
            resourceCollectionType(model.resourceCollectionType);
            nextToken(model.nextToken);
        }

        public final String getResourceCollectionType() {
            return resourceCollectionType;
        }

        public final void setResourceCollectionType(String resourceCollectionType) {
            this.resourceCollectionType = resourceCollectionType;
        }

        @Override
        public final Builder resourceCollectionType(String resourceCollectionType) {
            this.resourceCollectionType = resourceCollectionType;
            return this;
        }

        @Override
        public final Builder resourceCollectionType(ResourceCollectionType resourceCollectionType) {
            this.resourceCollectionType(resourceCollectionType == null ? null : resourceCollectionType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourceCollectionHealthRequest build() {
            return new DescribeResourceCollectionHealthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
