/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationResourceCollectionHealthRequest extends DevOpsGuruRequest
        implements
        ToCopyableBuilder<DescribeOrganizationResourceCollectionHealthRequest.Builder, DescribeOrganizationResourceCollectionHealthRequest> {
    private static final SdkField<String> ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationResourceCollectionType")
            .getter(getter(DescribeOrganizationResourceCollectionHealthRequest::organizationResourceCollectionTypeAsString))
            .setter(setter(Builder::organizationResourceCollectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationResourceCollectionType")
                    .build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(DescribeOrganizationResourceCollectionHealthRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitIds")
            .getter(getter(DescribeOrganizationResourceCollectionHealthRequest::organizationalUnitIds))
            .setter(setter(Builder::organizationalUnitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeOrganizationResourceCollectionHealthRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeOrganizationResourceCollectionHealthRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD, ACCOUNT_IDS_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationResourceCollectionType;

    private final List<String> accountIds;

    private final List<String> organizationalUnitIds;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeOrganizationResourceCollectionHealthRequest(BuilderImpl builder) {
        super(builder);
        this.organizationResourceCollectionType = builder.organizationResourceCollectionType;
        this.accountIds = builder.accountIds;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
     * are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationResourceCollectionType} will return
     * {@link OrganizationResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #organizationResourceCollectionTypeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
     *         resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
     *         Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
     *         Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined
     *         in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web
     *         Services CloudFormation stacks.
     * @see OrganizationResourceCollectionType
     */
    public final OrganizationResourceCollectionType organizationResourceCollectionType() {
        return OrganizationResourceCollectionType.fromValue(organizationResourceCollectionType);
    }

    /**
     * <p>
     * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources
     * are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services
     * CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps
     * Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are
     * tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #organizationResourceCollectionType} will return
     * {@link OrganizationResourceCollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #organizationResourceCollectionTypeAsString}.
     * </p>
     * 
     * @return An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
     *         resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
     *         Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
     *         Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined
     *         in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web
     *         Services CloudFormation stacks.
     * @see OrganizationResourceCollectionType
     */
    public final String organizationResourceCollectionTypeAsString() {
        return organizationResourceCollectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOrganizationalUnitIds() {
        return organizationalUnitIds != null && !(organizationalUnitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the organizational unit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitIds} method.
     * </p>
     * 
     * @return The ID of the organizational unit.
     */
    public final List<String> organizationalUnitIds() {
        return organizationalUnitIds;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If this value is null, it
     * retrieves the first page.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If this value is
     *         null, it retrieves the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call
     * with the returned <code>nextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve the remaining results, make
     *         another call with the returned <code>nextToken</code> value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationResourceCollectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnitIds() ? organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResourceCollectionHealthRequest)) {
            return false;
        }
        DescribeOrganizationResourceCollectionHealthRequest other = (DescribeOrganizationResourceCollectionHealthRequest) obj;
        return Objects.equals(organizationResourceCollectionTypeAsString(), other.organizationResourceCollectionTypeAsString())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds()
                && Objects.equals(organizationalUnitIds(), other.organizationalUnitIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeOrganizationResourceCollectionHealthRequest")
                .add("OrganizationResourceCollectionType", organizationResourceCollectionTypeAsString())
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("OrganizationalUnitIds", hasOrganizationalUnitIds() ? organizationalUnitIds() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationResourceCollectionType":
            return Optional.ofNullable(clazz.cast(organizationResourceCollectionTypeAsString()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "OrganizationalUnitIds":
            return Optional.ofNullable(clazz.cast(organizationalUnitIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationResourceCollectionType", ORGANIZATION_RESOURCE_COLLECTION_TYPE_FIELD);
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResourceCollectionHealthRequest, T> g) {
        return obj -> g.apply((DescribeOrganizationResourceCollectionHealthRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeOrganizationResourceCollectionHealthRequest> {
        /**
         * <p>
         * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         * resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
         * Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services
         * tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the
         * stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services
         * CloudFormation stacks.
         * </p>
         * 
         * @param organizationResourceCollectionType
         *        An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         *        resources are defined. The two types of Amazon Web Services resource collections supported are Amazon
         *        Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
         *        Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are
         *        defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500
         *        Amazon Web Services CloudFormation stacks.
         * @see OrganizationResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceCollectionType
         */
        Builder organizationResourceCollectionType(String organizationResourceCollectionType);

        /**
         * <p>
         * An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         * resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web
         * Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services
         * tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the
         * stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services
         * CloudFormation stacks.
         * </p>
         * 
         * @param organizationResourceCollectionType
         *        An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services
         *        resources are defined. The two types of Amazon Web Services resource collections supported are Amazon
         *        Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web
         *        Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are
         *        defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500
         *        Amazon Web Services CloudFormation stacks.
         * @see OrganizationResourceCollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrganizationResourceCollectionType
         */
        Builder organizationResourceCollectionType(OrganizationResourceCollectionType organizationResourceCollectionType);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountIds
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * The ID of the organizational unit.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The ID of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(Collection<String> organizationalUnitIds);

        /**
         * <p>
         * The ID of the organizational unit.
         * </p>
         * 
         * @param organizationalUnitIds
         *        The ID of the organizational unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitIds(String... organizationalUnitIds);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If this value is null,
         * it retrieves the first page.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If this value is
         *        null, it retrieves the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another
         * call with the returned <code>nextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve the remaining results, make
         *        another call with the returned <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DevOpsGuruRequest.BuilderImpl implements Builder {
        private String organizationResourceCollectionType;

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResourceCollectionHealthRequest model) {
            super(model);
            organizationResourceCollectionType(model.organizationResourceCollectionType);
            accountIds(model.accountIds);
            organizationalUnitIds(model.organizationalUnitIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getOrganizationResourceCollectionType() {
            return organizationResourceCollectionType;
        }

        public final void setOrganizationResourceCollectionType(String organizationResourceCollectionType) {
            this.organizationResourceCollectionType = organizationResourceCollectionType;
        }

        @Override
        public final Builder organizationResourceCollectionType(String organizationResourceCollectionType) {
            this.organizationResourceCollectionType = organizationResourceCollectionType;
            return this;
        }

        @Override
        public final Builder organizationResourceCollectionType(
                OrganizationResourceCollectionType organizationResourceCollectionType) {
            this.organizationResourceCollectionType(organizationResourceCollectionType == null ? null
                    : organizationResourceCollectionType.toString());
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String... organizationalUnitIds) {
            organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOrganizationResourceCollectionHealthRequest build() {
            return new DescribeOrganizationResourceCollectionHealthRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
