/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyResponse extends DevOpsGuruResponse implements
        ToCopyableBuilder<DescribeAnomalyResponse.Builder, DescribeAnomalyResponse> {
    private static final SdkField<ProactiveAnomaly> PROACTIVE_ANOMALY_FIELD = SdkField
            .<ProactiveAnomaly> builder(MarshallingType.SDK_POJO).memberName("ProactiveAnomaly")
            .getter(getter(DescribeAnomalyResponse::proactiveAnomaly)).setter(setter(Builder::proactiveAnomaly))
            .constructor(ProactiveAnomaly::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveAnomaly").build()).build();

    private static final SdkField<ReactiveAnomaly> REACTIVE_ANOMALY_FIELD = SdkField
            .<ReactiveAnomaly> builder(MarshallingType.SDK_POJO).memberName("ReactiveAnomaly")
            .getter(getter(DescribeAnomalyResponse::reactiveAnomaly)).setter(setter(Builder::reactiveAnomaly))
            .constructor(ReactiveAnomaly::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveAnomaly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_ANOMALY_FIELD,
            REACTIVE_ANOMALY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ProactiveAnomaly proactiveAnomaly;

    private final ReactiveAnomaly reactiveAnomaly;

    private DescribeAnomalyResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveAnomaly = builder.proactiveAnomaly;
        this.reactiveAnomaly = builder.reactiveAnomaly;
    }

    /**
     * <p>
     * A <code>ProactiveAnomaly</code> object that represents the requested anomaly.
     * </p>
     * 
     * @return A <code>ProactiveAnomaly</code> object that represents the requested anomaly.
     */
    public final ProactiveAnomaly proactiveAnomaly() {
        return proactiveAnomaly;
    }

    /**
     * <p>
     * A <code>ReactiveAnomaly</code> object that represents the requested anomaly.
     * </p>
     * 
     * @return A <code>ReactiveAnomaly</code> object that represents the requested anomaly.
     */
    public final ReactiveAnomaly reactiveAnomaly() {
        return reactiveAnomaly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proactiveAnomaly());
        hashCode = 31 * hashCode + Objects.hashCode(reactiveAnomaly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyResponse)) {
            return false;
        }
        DescribeAnomalyResponse other = (DescribeAnomalyResponse) obj;
        return Objects.equals(proactiveAnomaly(), other.proactiveAnomaly())
                && Objects.equals(reactiveAnomaly(), other.reactiveAnomaly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyResponse").add("ProactiveAnomaly", proactiveAnomaly())
                .add("ReactiveAnomaly", reactiveAnomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProactiveAnomaly":
            return Optional.ofNullable(clazz.cast(proactiveAnomaly()));
        case "ReactiveAnomaly":
            return Optional.ofNullable(clazz.cast(reactiveAnomaly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProactiveAnomaly", PROACTIVE_ANOMALY_FIELD);
        map.put("ReactiveAnomaly", REACTIVE_ANOMALY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DevOpsGuruResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAnomalyResponse> {
        /**
         * <p>
         * A <code>ProactiveAnomaly</code> object that represents the requested anomaly.
         * </p>
         * 
         * @param proactiveAnomaly
         *        A <code>ProactiveAnomaly</code> object that represents the requested anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proactiveAnomaly(ProactiveAnomaly proactiveAnomaly);

        /**
         * <p>
         * A <code>ProactiveAnomaly</code> object that represents the requested anomaly.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProactiveAnomaly.Builder} avoiding the
         * need to create one manually via {@link ProactiveAnomaly#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProactiveAnomaly.Builder#build()} is called immediately and its
         * result is passed to {@link #proactiveAnomaly(ProactiveAnomaly)}.
         * 
         * @param proactiveAnomaly
         *        a consumer that will call methods on {@link ProactiveAnomaly.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proactiveAnomaly(ProactiveAnomaly)
         */
        default Builder proactiveAnomaly(Consumer<ProactiveAnomaly.Builder> proactiveAnomaly) {
            return proactiveAnomaly(ProactiveAnomaly.builder().applyMutation(proactiveAnomaly).build());
        }

        /**
         * <p>
         * A <code>ReactiveAnomaly</code> object that represents the requested anomaly.
         * </p>
         * 
         * @param reactiveAnomaly
         *        A <code>ReactiveAnomaly</code> object that represents the requested anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactiveAnomaly(ReactiveAnomaly reactiveAnomaly);

        /**
         * <p>
         * A <code>ReactiveAnomaly</code> object that represents the requested anomaly.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReactiveAnomaly.Builder} avoiding the
         * need to create one manually via {@link ReactiveAnomaly#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReactiveAnomaly.Builder#build()} is called immediately and its
         * result is passed to {@link #reactiveAnomaly(ReactiveAnomaly)}.
         * 
         * @param reactiveAnomaly
         *        a consumer that will call methods on {@link ReactiveAnomaly.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reactiveAnomaly(ReactiveAnomaly)
         */
        default Builder reactiveAnomaly(Consumer<ReactiveAnomaly.Builder> reactiveAnomaly) {
            return reactiveAnomaly(ReactiveAnomaly.builder().applyMutation(reactiveAnomaly).build());
        }
    }

    static final class BuilderImpl extends DevOpsGuruResponse.BuilderImpl implements Builder {
        private ProactiveAnomaly proactiveAnomaly;

        private ReactiveAnomaly reactiveAnomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyResponse model) {
            super(model);
            proactiveAnomaly(model.proactiveAnomaly);
            reactiveAnomaly(model.reactiveAnomaly);
        }

        public final ProactiveAnomaly.Builder getProactiveAnomaly() {
            return proactiveAnomaly != null ? proactiveAnomaly.toBuilder() : null;
        }

        public final void setProactiveAnomaly(ProactiveAnomaly.BuilderImpl proactiveAnomaly) {
            this.proactiveAnomaly = proactiveAnomaly != null ? proactiveAnomaly.build() : null;
        }

        @Override
        public final Builder proactiveAnomaly(ProactiveAnomaly proactiveAnomaly) {
            this.proactiveAnomaly = proactiveAnomaly;
            return this;
        }

        public final ReactiveAnomaly.Builder getReactiveAnomaly() {
            return reactiveAnomaly != null ? reactiveAnomaly.toBuilder() : null;
        }

        public final void setReactiveAnomaly(ReactiveAnomaly.BuilderImpl reactiveAnomaly) {
            this.reactiveAnomaly = reactiveAnomaly != null ? reactiveAnomaly.build() : null;
        }

        @Override
        public final Builder reactiveAnomaly(ReactiveAnomaly reactiveAnomaly) {
            this.reactiveAnomaly = reactiveAnomaly;
            return this;
        }

        @Override
        public DescribeAnomalyResponse build() {
            return new DescribeAnomalyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
