/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics
 * analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web
 * Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountHealth implements SdkPojo, Serializable, ToCopyableBuilder<AccountHealth.Builder, AccountHealth> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AccountHealth::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<AccountInsightHealth> INSIGHT_FIELD = SdkField
            .<AccountInsightHealth> builder(MarshallingType.SDK_POJO).memberName("Insight")
            .getter(getter(AccountHealth::insight)).setter(setter(Builder::insight)).constructor(AccountInsightHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            INSIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final AccountInsightHealth insight;

    private AccountHealth(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.insight = builder.insight;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Information about the health of the Amazon Web Services resources in your account, including the number of open
     * proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
     * </p>
     * 
     * @return Information about the health of the Amazon Web Services resources in your account, including the number
     *         of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
     */
    public final AccountInsightHealth insight() {
        return insight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(insight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountHealth)) {
            return false;
        }
        AccountHealth other = (AccountHealth) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(insight(), other.insight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountHealth").add("AccountId", accountId()).add("Insight", insight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Insight":
            return Optional.ofNullable(clazz.cast(insight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountHealth, T> g) {
        return obj -> g.apply((AccountHealth) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountHealth> {
        /**
         * <p>
         * The ID of the Amazon Web Services account.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Information about the health of the Amazon Web Services resources in your account, including the number of
         * open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
         * </p>
         * 
         * @param insight
         *        Information about the health of the Amazon Web Services resources in your account, including the
         *        number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed
         *        insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insight(AccountInsightHealth insight);

        /**
         * <p>
         * Information about the health of the Amazon Web Services resources in your account, including the number of
         * open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountInsightHealth.Builder} avoiding
         * the need to create one manually via {@link AccountInsightHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountInsightHealth.Builder#build()} is called immediately and
         * its result is passed to {@link #insight(AccountInsightHealth)}.
         * 
         * @param insight
         *        a consumer that will call methods on {@link AccountInsightHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insight(AccountInsightHealth)
         */
        default Builder insight(Consumer<AccountInsightHealth.Builder> insight) {
            return insight(AccountInsightHealth.builder().applyMutation(insight).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private AccountInsightHealth insight;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountHealth model) {
            accountId(model.accountId);
            insight(model.insight);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final AccountInsightHealth.Builder getInsight() {
            return insight != null ? insight.toBuilder() : null;
        }

        public final void setInsight(AccountInsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(AccountInsightHealth insight) {
            this.insight = insight;
            return this;
        }

        @Override
        public AccountHealth build() {
            return new AccountHealth(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
