/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveInsight;
import software.amazon.awssdk.services.devopsguru.model.ReactiveInsight;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInsightResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeInsightResponse> {
    private static final SdkField<ProactiveInsight> PROACTIVE_INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProactiveInsight").getter(DescribeInsightResponse.getter(DescribeInsightResponse::proactiveInsight)).setter(DescribeInsightResponse.setter(Builder::proactiveInsight)).constructor(ProactiveInsight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProactiveInsight").build()}).build();
    private static final SdkField<ReactiveInsight> REACTIVE_INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReactiveInsight").getter(DescribeInsightResponse.getter(DescribeInsightResponse::reactiveInsight)).setter(DescribeInsightResponse.setter(Builder::reactiveInsight)).constructor(ReactiveInsight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReactiveInsight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROACTIVE_INSIGHT_FIELD, REACTIVE_INSIGHT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProactiveInsight", PROACTIVE_INSIGHT_FIELD);
            this.put("ReactiveInsight", REACTIVE_INSIGHT_FIELD);
        }
    });
    private final ProactiveInsight proactiveInsight;
    private final ReactiveInsight reactiveInsight;

    private DescribeInsightResponse(BuilderImpl builder) {
        super(builder);
        this.proactiveInsight = builder.proactiveInsight;
        this.reactiveInsight = builder.reactiveInsight;
    }

    public final ProactiveInsight proactiveInsight() {
        return this.proactiveInsight;
    }

    public final ReactiveInsight reactiveInsight() {
        return this.reactiveInsight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.proactiveInsight());
        hashCode = 31 * hashCode + Objects.hashCode(this.reactiveInsight());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInsightResponse)) {
            return false;
        }
        DescribeInsightResponse other = (DescribeInsightResponse)((Object)obj);
        return Objects.equals(this.proactiveInsight(), other.proactiveInsight()) && Objects.equals(this.reactiveInsight(), other.reactiveInsight());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInsightResponse").add("ProactiveInsight", (Object)this.proactiveInsight()).add("ReactiveInsight", (Object)this.reactiveInsight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProactiveInsight": {
                return Optional.ofNullable(clazz.cast(this.proactiveInsight()));
            }
            case "ReactiveInsight": {
                return Optional.ofNullable(clazz.cast(this.reactiveInsight()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInsightResponse, T> g) {
        return obj -> g.apply((DescribeInsightResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private ProactiveInsight proactiveInsight;
        private ReactiveInsight reactiveInsight;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInsightResponse model) {
            super(model);
            this.proactiveInsight(model.proactiveInsight);
            this.reactiveInsight(model.reactiveInsight);
        }

        public final ProactiveInsight.Builder getProactiveInsight() {
            return this.proactiveInsight != null ? this.proactiveInsight.toBuilder() : null;
        }

        public final void setProactiveInsight(ProactiveInsight.BuilderImpl proactiveInsight) {
            this.proactiveInsight = proactiveInsight != null ? proactiveInsight.build() : null;
        }

        @Override
        public final Builder proactiveInsight(ProactiveInsight proactiveInsight) {
            this.proactiveInsight = proactiveInsight;
            return this;
        }

        public final ReactiveInsight.Builder getReactiveInsight() {
            return this.reactiveInsight != null ? this.reactiveInsight.toBuilder() : null;
        }

        public final void setReactiveInsight(ReactiveInsight.BuilderImpl reactiveInsight) {
            this.reactiveInsight = reactiveInsight != null ? reactiveInsight.build() : null;
        }

        @Override
        public final Builder reactiveInsight(ReactiveInsight reactiveInsight) {
            this.reactiveInsight = reactiveInsight;
            return this;
        }

        @Override
        public DescribeInsightResponse build() {
            return new DescribeInsightResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInsightResponse> {
        public Builder proactiveInsight(ProactiveInsight var1);

        default public Builder proactiveInsight(Consumer<ProactiveInsight.Builder> proactiveInsight) {
            return this.proactiveInsight((ProactiveInsight)((ProactiveInsight.Builder)ProactiveInsight.builder().applyMutation(proactiveInsight)).build());
        }

        public Builder reactiveInsight(ReactiveInsight var1);

        default public Builder reactiveInsight(Consumer<ReactiveInsight.Builder> reactiveInsight) {
            return this.reactiveInsight((ReactiveInsight)((ReactiveInsight.Builder)ReactiveInsight.builder().applyMutation(reactiveInsight)).build());
        }
    }
}

