/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode;
import software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair;
import software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchMetricsDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchMetricsDataSummary> {
    private static final SdkField<List<TimestampMetricValuePair>> TIMESTAMP_METRIC_VALUE_PAIR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TimestampMetricValuePairList").getter(CloudWatchMetricsDataSummary.getter(CloudWatchMetricsDataSummary::timestampMetricValuePairList)).setter(CloudWatchMetricsDataSummary.setter(Builder::timestampMetricValuePairList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampMetricValuePairList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimestampMetricValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(CloudWatchMetricsDataSummary.getter(CloudWatchMetricsDataSummary::statusCodeAsString)).setter(CloudWatchMetricsDataSummary.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_METRIC_VALUE_PAIR_LIST_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TimestampMetricValuePairList", TIMESTAMP_METRIC_VALUE_PAIR_LIST_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<TimestampMetricValuePair> timestampMetricValuePairList;
    private final String statusCode;

    private CloudWatchMetricsDataSummary(BuilderImpl builder) {
        this.timestampMetricValuePairList = builder.timestampMetricValuePairList;
        this.statusCode = builder.statusCode;
    }

    public final boolean hasTimestampMetricValuePairList() {
        return this.timestampMetricValuePairList != null && !(this.timestampMetricValuePairList instanceof SdkAutoConstructList);
    }

    public final List<TimestampMetricValuePair> timestampMetricValuePairList() {
        return this.timestampMetricValuePairList;
    }

    public final CloudWatchMetricDataStatusCode statusCode() {
        return CloudWatchMetricDataStatusCode.fromValue(this.statusCode);
    }

    public final String statusCodeAsString() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestampMetricValuePairList() ? this.timestampMetricValuePairList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchMetricsDataSummary)) {
            return false;
        }
        CloudWatchMetricsDataSummary other = (CloudWatchMetricsDataSummary)obj;
        return this.hasTimestampMetricValuePairList() == other.hasTimestampMetricValuePairList() && Objects.equals(this.timestampMetricValuePairList(), other.timestampMetricValuePairList()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchMetricsDataSummary").add("TimestampMetricValuePairList", this.hasTimestampMetricValuePairList() ? this.timestampMetricValuePairList() : null).add("StatusCode", (Object)this.statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimestampMetricValuePairList": {
                return Optional.ofNullable(clazz.cast(this.timestampMetricValuePairList()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchMetricsDataSummary, T> g) {
        return obj -> g.apply((CloudWatchMetricsDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TimestampMetricValuePair> timestampMetricValuePairList = DefaultSdkAutoConstructList.getInstance();
        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchMetricsDataSummary model) {
            this.timestampMetricValuePairList(model.timestampMetricValuePairList);
            this.statusCode(model.statusCode);
        }

        public final List<TimestampMetricValuePair.Builder> getTimestampMetricValuePairList() {
            List<TimestampMetricValuePair.Builder> result = TimestampMetricValuePairListCopier.copyToBuilder(this.timestampMetricValuePairList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimestampMetricValuePairList(Collection<TimestampMetricValuePair.BuilderImpl> timestampMetricValuePairList) {
            this.timestampMetricValuePairList = TimestampMetricValuePairListCopier.copyFromBuilder(timestampMetricValuePairList);
        }

        @Override
        public final Builder timestampMetricValuePairList(Collection<TimestampMetricValuePair> timestampMetricValuePairList) {
            this.timestampMetricValuePairList = TimestampMetricValuePairListCopier.copy(timestampMetricValuePairList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampMetricValuePairList(TimestampMetricValuePair ... timestampMetricValuePairList) {
            this.timestampMetricValuePairList(Arrays.asList(timestampMetricValuePairList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestampMetricValuePairList(Consumer<TimestampMetricValuePair.Builder> ... timestampMetricValuePairList) {
            this.timestampMetricValuePairList(Stream.of(timestampMetricValuePairList).map(c -> (TimestampMetricValuePair)((TimestampMetricValuePair.Builder)TimestampMetricValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(CloudWatchMetricDataStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public CloudWatchMetricsDataSummary build() {
            return new CloudWatchMetricsDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchMetricsDataSummary> {
        public Builder timestampMetricValuePairList(Collection<TimestampMetricValuePair> var1);

        public Builder timestampMetricValuePairList(TimestampMetricValuePair ... var1);

        public Builder timestampMetricValuePairList(Consumer<TimestampMetricValuePair.Builder> ... var1);

        public Builder statusCode(String var1);

        public Builder statusCode(CloudWatchMetricDataStatusCode var1);
    }
}

