/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaliesCopier;
import software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomaly;
import software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEvent;
import software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Recommendation.getter(Recommendation::description)).setter(Recommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Link").getter(Recommendation.getter(Recommendation::link)).setter(Recommendation.setter(Builder::link)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Recommendation.getter(Recommendation::name)).setter(Recommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(Recommendation.getter(Recommendation::reason)).setter(Recommendation.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<List<RecommendationRelatedEvent>> RELATED_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedEvents").getter(Recommendation.getter(Recommendation::relatedEvents)).setter(Recommendation.setter(Builder::relatedEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationRelatedEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecommendationRelatedAnomaly>> RELATED_ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedAnomalies").getter(Recommendation.getter(Recommendation::relatedAnomalies)).setter(Recommendation.setter(Builder::relatedAnomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedAnomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationRelatedAnomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(Recommendation.getter(Recommendation::category)).setter(Recommendation.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LINK_FIELD, NAME_FIELD, REASON_FIELD, RELATED_EVENTS_FIELD, RELATED_ANOMALIES_FIELD, CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Link", LINK_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Reason", REASON_FIELD);
            this.put("RelatedEvents", RELATED_EVENTS_FIELD);
            this.put("RelatedAnomalies", RELATED_ANOMALIES_FIELD);
            this.put("Category", CATEGORY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String link;
    private final String name;
    private final String reason;
    private final List<RecommendationRelatedEvent> relatedEvents;
    private final List<RecommendationRelatedAnomaly> relatedAnomalies;
    private final String category;

    private Recommendation(BuilderImpl builder) {
        this.description = builder.description;
        this.link = builder.link;
        this.name = builder.name;
        this.reason = builder.reason;
        this.relatedEvents = builder.relatedEvents;
        this.relatedAnomalies = builder.relatedAnomalies;
        this.category = builder.category;
    }

    public final String description() {
        return this.description;
    }

    public final String link() {
        return this.link;
    }

    public final String name() {
        return this.name;
    }

    public final String reason() {
        return this.reason;
    }

    public final boolean hasRelatedEvents() {
        return this.relatedEvents != null && !(this.relatedEvents instanceof SdkAutoConstructList);
    }

    public final List<RecommendationRelatedEvent> relatedEvents() {
        return this.relatedEvents;
    }

    public final boolean hasRelatedAnomalies() {
        return this.relatedAnomalies != null && !(this.relatedAnomalies instanceof SdkAutoConstructList);
    }

    public final List<RecommendationRelatedAnomaly> relatedAnomalies() {
        return this.relatedAnomalies;
    }

    public final String category() {
        return this.category;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.link());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedEvents() ? this.relatedEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedAnomalies() ? this.relatedAnomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.link(), other.link()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.reason(), other.reason()) && this.hasRelatedEvents() == other.hasRelatedEvents() && Objects.equals(this.relatedEvents(), other.relatedEvents()) && this.hasRelatedAnomalies() == other.hasRelatedAnomalies() && Objects.equals(this.relatedAnomalies(), other.relatedAnomalies()) && Objects.equals(this.category(), other.category());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("Description", (Object)this.description()).add("Link", (Object)this.link()).add("Name", (Object)this.name()).add("Reason", (Object)this.reason()).add("RelatedEvents", this.hasRelatedEvents() ? this.relatedEvents() : null).add("RelatedAnomalies", this.hasRelatedAnomalies() ? this.relatedAnomalies() : null).add("Category", (Object)this.category()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Link": {
                return Optional.ofNullable(clazz.cast(this.link()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "RelatedEvents": {
                return Optional.ofNullable(clazz.cast(this.relatedEvents()));
            }
            case "RelatedAnomalies": {
                return Optional.ofNullable(clazz.cast(this.relatedAnomalies()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String link;
        private String name;
        private String reason;
        private List<RecommendationRelatedEvent> relatedEvents = DefaultSdkAutoConstructList.getInstance();
        private List<RecommendationRelatedAnomaly> relatedAnomalies = DefaultSdkAutoConstructList.getInstance();
        private String category;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.description(model.description);
            this.link(model.link);
            this.name(model.name);
            this.reason(model.reason);
            this.relatedEvents(model.relatedEvents);
            this.relatedAnomalies(model.relatedAnomalies);
            this.category(model.category);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLink() {
            return this.link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final List<RecommendationRelatedEvent.Builder> getRelatedEvents() {
            List<RecommendationRelatedEvent.Builder> result = RecommendationRelatedEventsCopier.copyToBuilder(this.relatedEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedEvents(Collection<RecommendationRelatedEvent.BuilderImpl> relatedEvents) {
            this.relatedEvents = RecommendationRelatedEventsCopier.copyFromBuilder(relatedEvents);
        }

        @Override
        public final Builder relatedEvents(Collection<RecommendationRelatedEvent> relatedEvents) {
            this.relatedEvents = RecommendationRelatedEventsCopier.copy(relatedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(RecommendationRelatedEvent ... relatedEvents) {
            this.relatedEvents(Arrays.asList(relatedEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedEvents(Consumer<RecommendationRelatedEvent.Builder> ... relatedEvents) {
            this.relatedEvents(Stream.of(relatedEvents).map(c -> (RecommendationRelatedEvent)((RecommendationRelatedEvent.Builder)RecommendationRelatedEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecommendationRelatedAnomaly.Builder> getRelatedAnomalies() {
            List<RecommendationRelatedAnomaly.Builder> result = RecommendationRelatedAnomaliesCopier.copyToBuilder(this.relatedAnomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedAnomalies(Collection<RecommendationRelatedAnomaly.BuilderImpl> relatedAnomalies) {
            this.relatedAnomalies = RecommendationRelatedAnomaliesCopier.copyFromBuilder(relatedAnomalies);
        }

        @Override
        public final Builder relatedAnomalies(Collection<RecommendationRelatedAnomaly> relatedAnomalies) {
            this.relatedAnomalies = RecommendationRelatedAnomaliesCopier.copy(relatedAnomalies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedAnomalies(RecommendationRelatedAnomaly ... relatedAnomalies) {
            this.relatedAnomalies(Arrays.asList(relatedAnomalies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedAnomalies(Consumer<RecommendationRelatedAnomaly.Builder> ... relatedAnomalies) {
            this.relatedAnomalies(Stream.of(relatedAnomalies).map(c -> (RecommendationRelatedAnomaly)((RecommendationRelatedAnomaly.Builder)RecommendationRelatedAnomaly.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder description(String var1);

        public Builder link(String var1);

        public Builder name(String var1);

        public Builder reason(String var1);

        public Builder relatedEvents(Collection<RecommendationRelatedEvent> var1);

        public Builder relatedEvents(RecommendationRelatedEvent ... var1);

        public Builder relatedEvents(Consumer<RecommendationRelatedEvent.Builder> ... var1);

        public Builder relatedAnomalies(Collection<RecommendationRelatedAnomaly> var1);

        public Builder relatedAnomalies(RecommendationRelatedAnomaly ... var1);

        public Builder relatedAnomalies(Consumer<RecommendationRelatedAnomaly.Builder> ... var1);

        public Builder category(String var1);
    }
}

