/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CostEstimationResourceCollectionFilter;
import software.amazon.awssdk.services.devopsguru.model.CostEstimationStatus;
import software.amazon.awssdk.services.devopsguru.model.CostEstimationTimeRange;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost;
import software.amazon.awssdk.services.devopsguru.model.ServiceResourceCostsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostEstimationResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, GetCostEstimationResponse> {
    private static final SdkField<CostEstimationResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::resourceCollection)).setter(GetCostEstimationResponse.setter(Builder::resourceCollection)).constructor(CostEstimationResourceCollectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::statusAsString)).setter(GetCostEstimationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<ServiceResourceCost>> COSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Costs").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::costs)).setter(GetCostEstimationResponse.setter(Builder::costs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Costs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceResourceCost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CostEstimationTimeRange> TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRange").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::timeRange)).setter(GetCostEstimationResponse.setter(Builder::timeRange)).constructor(CostEstimationTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()}).build();
    private static final SdkField<Double> TOTAL_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TotalCost").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::totalCost)).setter(GetCostEstimationResponse.setter(Builder::totalCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCost").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetCostEstimationResponse.getter(GetCostEstimationResponse::nextToken)).setter(GetCostEstimationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_COLLECTION_FIELD, STATUS_FIELD, COSTS_FIELD, TIME_RANGE_FIELD, TOTAL_COST_FIELD, NEXT_TOKEN_FIELD));
    private final CostEstimationResourceCollectionFilter resourceCollection;
    private final String status;
    private final List<ServiceResourceCost> costs;
    private final CostEstimationTimeRange timeRange;
    private final Double totalCost;
    private final String nextToken;

    private GetCostEstimationResponse(BuilderImpl builder) {
        super(builder);
        this.resourceCollection = builder.resourceCollection;
        this.status = builder.status;
        this.costs = builder.costs;
        this.timeRange = builder.timeRange;
        this.totalCost = builder.totalCost;
        this.nextToken = builder.nextToken;
    }

    public final CostEstimationResourceCollectionFilter resourceCollection() {
        return this.resourceCollection;
    }

    public final CostEstimationStatus status() {
        return CostEstimationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasCosts() {
        return this.costs != null && !(this.costs instanceof SdkAutoConstructList);
    }

    public final List<ServiceResourceCost> costs() {
        return this.costs;
    }

    public final CostEstimationTimeRange timeRange() {
        return this.timeRange;
    }

    public final Double totalCost() {
        return this.totalCost;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCosts() ? this.costs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostEstimationResponse)) {
            return false;
        }
        GetCostEstimationResponse other = (GetCostEstimationResponse)((Object)obj);
        return Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasCosts() == other.hasCosts() && Objects.equals(this.costs(), other.costs()) && Objects.equals(this.timeRange(), other.timeRange()) && Objects.equals(this.totalCost(), other.totalCost()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostEstimationResponse").add("ResourceCollection", (Object)this.resourceCollection()).add("Status", (Object)this.statusAsString()).add("Costs", this.hasCosts() ? this.costs() : null).add("TimeRange", (Object)this.timeRange()).add("TotalCost", (Object)this.totalCost()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Costs": {
                return Optional.ofNullable(clazz.cast(this.costs()));
            }
            case "TimeRange": {
                return Optional.ofNullable(clazz.cast(this.timeRange()));
            }
            case "TotalCost": {
                return Optional.ofNullable(clazz.cast(this.totalCost()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostEstimationResponse, T> g) {
        return obj -> g.apply((GetCostEstimationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private CostEstimationResourceCollectionFilter resourceCollection;
        private String status;
        private List<ServiceResourceCost> costs = DefaultSdkAutoConstructList.getInstance();
        private CostEstimationTimeRange timeRange;
        private Double totalCost;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostEstimationResponse model) {
            super(model);
            this.resourceCollection(model.resourceCollection);
            this.status(model.status);
            this.costs(model.costs);
            this.timeRange(model.timeRange);
            this.totalCost(model.totalCost);
            this.nextToken(model.nextToken);
        }

        public final CostEstimationResourceCollectionFilter.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(CostEstimationResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(CostEstimationResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CostEstimationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<ServiceResourceCost.Builder> getCosts() {
            List<ServiceResourceCost.Builder> result = ServiceResourceCostsCopier.copyToBuilder(this.costs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCosts(Collection<ServiceResourceCost.BuilderImpl> costs) {
            this.costs = ServiceResourceCostsCopier.copyFromBuilder(costs);
        }

        @Override
        public final Builder costs(Collection<ServiceResourceCost> costs) {
            this.costs = ServiceResourceCostsCopier.copy(costs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costs(ServiceResourceCost ... costs) {
            this.costs(Arrays.asList(costs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costs(Consumer<ServiceResourceCost.Builder> ... costs) {
            this.costs(Stream.of(costs).map(c -> (ServiceResourceCost)((ServiceResourceCost.Builder)ServiceResourceCost.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CostEstimationTimeRange.Builder getTimeRange() {
            return this.timeRange != null ? this.timeRange.toBuilder() : null;
        }

        public final void setTimeRange(CostEstimationTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(CostEstimationTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final Double getTotalCost() {
            return this.totalCost;
        }

        public final void setTotalCost(Double totalCost) {
            this.totalCost = totalCost;
        }

        @Override
        public final Builder totalCost(Double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCostEstimationResponse build() {
            return new GetCostEstimationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostEstimationResponse> {
        public Builder resourceCollection(CostEstimationResourceCollectionFilter var1);

        default public Builder resourceCollection(Consumer<CostEstimationResourceCollectionFilter.Builder> resourceCollection) {
            return this.resourceCollection((CostEstimationResourceCollectionFilter)((CostEstimationResourceCollectionFilter.Builder)CostEstimationResourceCollectionFilter.builder().applyMutation(resourceCollection)).build());
        }

        public Builder status(String var1);

        public Builder status(CostEstimationStatus var1);

        public Builder costs(Collection<ServiceResourceCost> var1);

        public Builder costs(ServiceResourceCost ... var1);

        public Builder costs(Consumer<ServiceResourceCost.Builder> ... var1);

        public Builder timeRange(CostEstimationTimeRange var1);

        default public Builder timeRange(Consumer<CostEstimationTimeRange.Builder> timeRange) {
            return this.timeRange((CostEstimationTimeRange)((CostEstimationTimeRange.Builder)CostEstimationTimeRange.builder().applyMutation(timeRange)).build());
        }

        public Builder totalCost(Double var1);

        public Builder nextToken(String var1);
    }
}

