/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationMessageType {
    NEW_INSIGHT("NEW_INSIGHT"),
    CLOSED_INSIGHT("CLOSED_INSIGHT"),
    NEW_ASSOCIATION("NEW_ASSOCIATION"),
    SEVERITY_UPGRADED("SEVERITY_UPGRADED"),
    NEW_RECOMMENDATION("NEW_RECOMMENDATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationMessageType> VALUE_MAP;
    private final String value;

    private NotificationMessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationMessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationMessageType> knownValues() {
        EnumSet<NotificationMessageType> knownValues = EnumSet.allOf(NotificationMessageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationMessageType.class, NotificationMessageType::toString);
    }
}

