/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.internal.UserAgentUtils;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse;
import software.amazon.awssdk.services.devopsguru.model.ProactiveAnomalySummary;
import software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary;

public class ListAnomaliesForInsightIterable
implements SdkIterable<ListAnomaliesForInsightResponse> {
    private final DevOpsGuruClient client;
    private final ListAnomaliesForInsightRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomaliesForInsightIterable(DevOpsGuruClient client, ListAnomaliesForInsightRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnomaliesForInsightResponseFetcher();
    }

    public Iterator<ListAnomaliesForInsightResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReactiveAnomalySummary> reactiveAnomalies() {
        Function<ListAnomaliesForInsightResponse, Iterator> getIterator = response -> {
            if (response != null && response.reactiveAnomalies() != null) {
                return response.reactiveAnomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ProactiveAnomalySummary> proactiveAnomalies() {
        Function<ListAnomaliesForInsightResponse, Iterator> getIterator = response -> {
            if (response != null && response.proactiveAnomalies() != null) {
                return response.proactiveAnomalies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnomaliesForInsightResponseFetcher
    implements SyncPageFetcher<ListAnomaliesForInsightResponse> {
        private ListAnomaliesForInsightResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomaliesForInsightResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomaliesForInsightResponse nextPage(ListAnomaliesForInsightResponse previousPage) {
            if (previousPage == null) {
                return ListAnomaliesForInsightIterable.this.client.listAnomaliesForInsight(ListAnomaliesForInsightIterable.this.firstRequest);
            }
            return ListAnomaliesForInsightIterable.this.client.listAnomaliesForInsight((ListAnomaliesForInsightRequest)((Object)ListAnomaliesForInsightIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

