/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifier;
import software.amazon.awssdk.services.devopsguru.model.MonitoredResourceIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMonitoredResourcesResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, ListMonitoredResourcesResponse> {
    private static final SdkField<List<MonitoredResourceIdentifier>> MONITORED_RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoredResourceIdentifiers").getter(ListMonitoredResourcesResponse.getter(ListMonitoredResourcesResponse::monitoredResourceIdentifiers)).setter(ListMonitoredResourcesResponse.setter(Builder::monitoredResourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoredResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMonitoredResourcesResponse.getter(ListMonitoredResourcesResponse::nextToken)).setter(ListMonitoredResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORED_RESOURCE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MonitoredResourceIdentifier> monitoredResourceIdentifiers;
    private final String nextToken;

    private ListMonitoredResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.monitoredResourceIdentifiers = builder.monitoredResourceIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMonitoredResourceIdentifiers() {
        return this.monitoredResourceIdentifiers != null && !(this.monitoredResourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<MonitoredResourceIdentifier> monitoredResourceIdentifiers() {
        return this.monitoredResourceIdentifiers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoredResourceIdentifiers() ? this.monitoredResourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoredResourcesResponse)) {
            return false;
        }
        ListMonitoredResourcesResponse other = (ListMonitoredResourcesResponse)((Object)obj);
        return this.hasMonitoredResourceIdentifiers() == other.hasMonitoredResourceIdentifiers() && Objects.equals(this.monitoredResourceIdentifiers(), other.monitoredResourceIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMonitoredResourcesResponse").add("MonitoredResourceIdentifiers", this.hasMonitoredResourceIdentifiers() ? this.monitoredResourceIdentifiers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoredResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoredResourcesResponse, T> g) {
        return obj -> g.apply((ListMonitoredResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<MonitoredResourceIdentifier> monitoredResourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoredResourcesResponse model) {
            super(model);
            this.monitoredResourceIdentifiers(model.monitoredResourceIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final List<MonitoredResourceIdentifier.Builder> getMonitoredResourceIdentifiers() {
            List<MonitoredResourceIdentifier.Builder> result = MonitoredResourceIdentifiersCopier.copyToBuilder(this.monitoredResourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoredResourceIdentifiers(Collection<MonitoredResourceIdentifier.BuilderImpl> monitoredResourceIdentifiers) {
            this.monitoredResourceIdentifiers = MonitoredResourceIdentifiersCopier.copyFromBuilder(monitoredResourceIdentifiers);
        }

        @Override
        public final Builder monitoredResourceIdentifiers(Collection<MonitoredResourceIdentifier> monitoredResourceIdentifiers) {
            this.monitoredResourceIdentifiers = MonitoredResourceIdentifiersCopier.copy(monitoredResourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoredResourceIdentifiers(MonitoredResourceIdentifier ... monitoredResourceIdentifiers) {
            this.monitoredResourceIdentifiers(Arrays.asList(monitoredResourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoredResourceIdentifiers(Consumer<MonitoredResourceIdentifier.Builder> ... monitoredResourceIdentifiers) {
            this.monitoredResourceIdentifiers(Stream.of(monitoredResourceIdentifiers).map(c -> (MonitoredResourceIdentifier)((MonitoredResourceIdentifier.Builder)MonitoredResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoredResourcesResponse build() {
            return new ListMonitoredResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMonitoredResourcesResponse> {
        public Builder monitoredResourceIdentifiers(Collection<MonitoredResourceIdentifier> var1);

        public Builder monitoredResourceIdentifiers(MonitoredResourceIdentifier ... var1);

        public Builder monitoredResourceIdentifiers(Consumer<MonitoredResourceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

