/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruBaseClientBuilder;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClientBuilder;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruServiceClientConfiguration;
import software.amazon.awssdk.services.devopsguru.endpoints.DevOpsGuruEndpointProvider;

@SdkInternalApi
final class DefaultDevOpsGuruClientBuilder
extends DefaultDevOpsGuruBaseClientBuilder<DevOpsGuruClientBuilder, DevOpsGuruClient>
implements DevOpsGuruClientBuilder {
    DefaultDevOpsGuruClientBuilder() {
    }

    @Override
    public DefaultDevOpsGuruClientBuilder endpointProvider(DevOpsGuruEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DevOpsGuruClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDevOpsGuruClientBuilder.validateClientOptions(clientConfiguration);
        DevOpsGuruServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDevOpsGuruClient client = new DefaultDevOpsGuruClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DevOpsGuruServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DevOpsGuruServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

