/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.DefaultDevOpsGuruBaseClientBuilder;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClient;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruAsyncClientBuilder;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruServiceClientConfiguration;
import software.amazon.awssdk.services.devopsguru.endpoints.DevOpsGuruEndpointProvider;

@SdkInternalApi
final class DefaultDevOpsGuruAsyncClientBuilder
extends DefaultDevOpsGuruBaseClientBuilder<DevOpsGuruAsyncClientBuilder, DevOpsGuruAsyncClient>
implements DevOpsGuruAsyncClientBuilder {
    DefaultDevOpsGuruAsyncClientBuilder() {
    }

    @Override
    public DefaultDevOpsGuruAsyncClientBuilder endpointProvider(DevOpsGuruEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DevOpsGuruAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDevOpsGuruAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DevOpsGuruServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDevOpsGuruAsyncClient client = new DefaultDevOpsGuruAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DevOpsGuruServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DevOpsGuruServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

