/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.AccountHealth;
import software.amazon.awssdk.services.devopsguru.model.AccountHealthsCopier;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth;
import software.amazon.awssdk.services.devopsguru.model.CloudFormationHealthsCopier;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealth;
import software.amazon.awssdk.services.devopsguru.model.ServiceHealthsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationResourceCollectionHealthResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationResourceCollectionHealthResponse> {
    private static final SdkField<List<CloudFormationHealth>> CLOUD_FORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CloudFormation").getter(DescribeOrganizationResourceCollectionHealthResponse.getter(DescribeOrganizationResourceCollectionHealthResponse::cloudFormation)).setter(DescribeOrganizationResourceCollectionHealthResponse.setter(Builder::cloudFormation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudFormationHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceHealth>> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Service").getter(DescribeOrganizationResourceCollectionHealthResponse.getter(DescribeOrganizationResourceCollectionHealthResponse::service)).setter(DescribeOrganizationResourceCollectionHealthResponse.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccountHealth>> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Account").getter(DescribeOrganizationResourceCollectionHealthResponse.getter(DescribeOrganizationResourceCollectionHealthResponse::account)).setter(DescribeOrganizationResourceCollectionHealthResponse.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationResourceCollectionHealthResponse.getter(DescribeOrganizationResourceCollectionHealthResponse::nextToken)).setter(DescribeOrganizationResourceCollectionHealthResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD, SERVICE_FIELD, ACCOUNT_FIELD, NEXT_TOKEN_FIELD));
    private final List<CloudFormationHealth> cloudFormation;
    private final List<ServiceHealth> service;
    private final List<AccountHealth> account;
    private final String nextToken;

    private DescribeOrganizationResourceCollectionHealthResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFormation = builder.cloudFormation;
        this.service = builder.service;
        this.account = builder.account;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCloudFormation() {
        return this.cloudFormation != null && !(this.cloudFormation instanceof SdkAutoConstructList);
    }

    public final List<CloudFormationHealth> cloudFormation() {
        return this.cloudFormation;
    }

    public final boolean hasService() {
        return this.service != null && !(this.service instanceof SdkAutoConstructList);
    }

    public final List<ServiceHealth> service() {
        return this.service;
    }

    public final boolean hasAccount() {
        return this.account != null && !(this.account instanceof SdkAutoConstructList);
    }

    public final List<AccountHealth> account() {
        return this.account;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudFormation() ? this.cloudFormation() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasService() ? this.service() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccount() ? this.account() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResourceCollectionHealthResponse)) {
            return false;
        }
        DescribeOrganizationResourceCollectionHealthResponse other = (DescribeOrganizationResourceCollectionHealthResponse)((Object)obj);
        return this.hasCloudFormation() == other.hasCloudFormation() && Objects.equals(this.cloudFormation(), other.cloudFormation()) && this.hasService() == other.hasService() && Objects.equals(this.service(), other.service()) && this.hasAccount() == other.hasAccount() && Objects.equals(this.account(), other.account()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationResourceCollectionHealthResponse").add("CloudFormation", this.hasCloudFormation() ? this.cloudFormation() : null).add("Service", this.hasService() ? this.service() : null).add("Account", this.hasAccount() ? this.account() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFormation": {
                return Optional.ofNullable(clazz.cast(this.cloudFormation()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "Account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResourceCollectionHealthResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationResourceCollectionHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private List<CloudFormationHealth> cloudFormation = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceHealth> service = DefaultSdkAutoConstructList.getInstance();
        private List<AccountHealth> account = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResourceCollectionHealthResponse model) {
            super(model);
            this.cloudFormation(model.cloudFormation);
            this.service(model.service);
            this.account(model.account);
            this.nextToken(model.nextToken);
        }

        public final List<CloudFormationHealth.Builder> getCloudFormation() {
            List<CloudFormationHealth.Builder> result = CloudFormationHealthsCopier.copyToBuilder(this.cloudFormation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudFormation(Collection<CloudFormationHealth.BuilderImpl> cloudFormation) {
            this.cloudFormation = CloudFormationHealthsCopier.copyFromBuilder(cloudFormation);
        }

        @Override
        @Transient
        public final Builder cloudFormation(Collection<CloudFormationHealth> cloudFormation) {
            this.cloudFormation = CloudFormationHealthsCopier.copy(cloudFormation);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudFormation(CloudFormationHealth ... cloudFormation) {
            this.cloudFormation(Arrays.asList(cloudFormation));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudFormation(Consumer<CloudFormationHealth.Builder> ... cloudFormation) {
            this.cloudFormation(Stream.of(cloudFormation).map(c -> (CloudFormationHealth)((CloudFormationHealth.Builder)CloudFormationHealth.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceHealth.Builder> getService() {
            List<ServiceHealth.Builder> result = ServiceHealthsCopier.copyToBuilder(this.service);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setService(Collection<ServiceHealth.BuilderImpl> service) {
            this.service = ServiceHealthsCopier.copyFromBuilder(service);
        }

        @Override
        @Transient
        public final Builder service(Collection<ServiceHealth> service) {
            this.service = ServiceHealthsCopier.copy(service);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder service(ServiceHealth ... service) {
            this.service(Arrays.asList(service));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder service(Consumer<ServiceHealth.Builder> ... service) {
            this.service(Stream.of(service).map(c -> (ServiceHealth)((ServiceHealth.Builder)ServiceHealth.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AccountHealth.Builder> getAccount() {
            List<AccountHealth.Builder> result = AccountHealthsCopier.copyToBuilder(this.account);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccount(Collection<AccountHealth.BuilderImpl> account) {
            this.account = AccountHealthsCopier.copyFromBuilder(account);
        }

        @Override
        @Transient
        public final Builder account(Collection<AccountHealth> account) {
            this.account = AccountHealthsCopier.copy(account);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder account(AccountHealth ... account) {
            this.account(Arrays.asList(account));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder account(Consumer<AccountHealth.Builder> ... account) {
            this.account(Stream.of(account).map(c -> (AccountHealth)((AccountHealth.Builder)AccountHealth.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationResourceCollectionHealthResponse build() {
            return new DescribeOrganizationResourceCollectionHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationResourceCollectionHealthResponse> {
        public Builder cloudFormation(Collection<CloudFormationHealth> var1);

        public Builder cloudFormation(CloudFormationHealth ... var1);

        public Builder cloudFormation(Consumer<CloudFormationHealth.Builder> ... var1);

        public Builder service(Collection<ServiceHealth> var1);

        public Builder service(ServiceHealth ... var1);

        public Builder service(Consumer<ServiceHealth.Builder> ... var1);

        public Builder account(Collection<AccountHealth> var1);

        public Builder account(AccountHealth ... var1);

        public Builder account(Consumer<AccountHealth.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

