/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devopsguru.DevOpsGuruClient;
import software.amazon.awssdk.services.devopsguru.model.AnomalousLogGroup;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest;
import software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse;

public class ListAnomalousLogGroupsIterable
implements SdkIterable<ListAnomalousLogGroupsResponse> {
    private final DevOpsGuruClient client;
    private final ListAnomalousLogGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomalousLogGroupsIterable(DevOpsGuruClient client, ListAnomalousLogGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAnomalousLogGroupsResponseFetcher();
    }

    public Iterator<ListAnomalousLogGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnomalousLogGroup> anomalousLogGroups() {
        Function<ListAnomalousLogGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalousLogGroups() != null) {
                return response.anomalousLogGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnomalousLogGroupsResponseFetcher
    implements SyncPageFetcher<ListAnomalousLogGroupsResponse> {
        private ListAnomalousLogGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalousLogGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomalousLogGroupsResponse nextPage(ListAnomalousLogGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalousLogGroupsIterable.this.client.listAnomalousLogGroups(ListAnomalousLogGroupsIterable.this.firstRequest);
            }
            return ListAnomalousLogGroupsIterable.this.client.listAnomalousLogGroups((ListAnomalousLogGroupsRequest)((Object)ListAnomalousLogGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

