/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationHealthResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationHealthResponse> {
    private static final SdkField<Integer> OPEN_REACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OpenReactiveInsights").getter(DescribeOrganizationHealthResponse.getter(DescribeOrganizationHealthResponse::openReactiveInsights)).setter(DescribeOrganizationHealthResponse.setter(Builder::openReactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenReactiveInsights").build()}).build();
    private static final SdkField<Integer> OPEN_PROACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OpenProactiveInsights").getter(DescribeOrganizationHealthResponse.getter(DescribeOrganizationHealthResponse::openProactiveInsights)).setter(DescribeOrganizationHealthResponse.setter(Builder::openProactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenProactiveInsights").build()}).build();
    private static final SdkField<Integer> METRICS_ANALYZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MetricsAnalyzed").getter(DescribeOrganizationHealthResponse.getter(DescribeOrganizationHealthResponse::metricsAnalyzed)).setter(DescribeOrganizationHealthResponse.setter(Builder::metricsAnalyzed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsAnalyzed").build()}).build();
    private static final SdkField<Long> RESOURCE_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ResourceHours").getter(DescribeOrganizationHealthResponse.getter(DescribeOrganizationHealthResponse::resourceHours)).setter(DescribeOrganizationHealthResponse.setter(Builder::resourceHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_REACTIVE_INSIGHTS_FIELD, OPEN_PROACTIVE_INSIGHTS_FIELD, METRICS_ANALYZED_FIELD, RESOURCE_HOURS_FIELD));
    private final Integer openReactiveInsights;
    private final Integer openProactiveInsights;
    private final Integer metricsAnalyzed;
    private final Long resourceHours;

    private DescribeOrganizationHealthResponse(BuilderImpl builder) {
        super(builder);
        this.openReactiveInsights = builder.openReactiveInsights;
        this.openProactiveInsights = builder.openProactiveInsights;
        this.metricsAnalyzed = builder.metricsAnalyzed;
        this.resourceHours = builder.resourceHours;
    }

    public final Integer openReactiveInsights() {
        return this.openReactiveInsights;
    }

    public final Integer openProactiveInsights() {
        return this.openProactiveInsights;
    }

    public final Integer metricsAnalyzed() {
        return this.metricsAnalyzed;
    }

    public final Long resourceHours() {
        return this.resourceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openReactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.openProactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsAnalyzed());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationHealthResponse)) {
            return false;
        }
        DescribeOrganizationHealthResponse other = (DescribeOrganizationHealthResponse)((Object)obj);
        return Objects.equals(this.openReactiveInsights(), other.openReactiveInsights()) && Objects.equals(this.openProactiveInsights(), other.openProactiveInsights()) && Objects.equals(this.metricsAnalyzed(), other.metricsAnalyzed()) && Objects.equals(this.resourceHours(), other.resourceHours());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationHealthResponse").add("OpenReactiveInsights", (Object)this.openReactiveInsights()).add("OpenProactiveInsights", (Object)this.openProactiveInsights()).add("MetricsAnalyzed", (Object)this.metricsAnalyzed()).add("ResourceHours", (Object)this.resourceHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenReactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.openReactiveInsights()));
            }
            case "OpenProactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.openProactiveInsights()));
            }
            case "MetricsAnalyzed": {
                return Optional.ofNullable(clazz.cast(this.metricsAnalyzed()));
            }
            case "ResourceHours": {
                return Optional.ofNullable(clazz.cast(this.resourceHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationHealthResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private Integer openReactiveInsights;
        private Integer openProactiveInsights;
        private Integer metricsAnalyzed;
        private Long resourceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationHealthResponse model) {
            super(model);
            this.openReactiveInsights(model.openReactiveInsights);
            this.openProactiveInsights(model.openProactiveInsights);
            this.metricsAnalyzed(model.metricsAnalyzed);
            this.resourceHours(model.resourceHours);
        }

        public final Integer getOpenReactiveInsights() {
            return this.openReactiveInsights;
        }

        public final void setOpenReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
        }

        @Override
        @Transient
        public final Builder openReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
            return this;
        }

        public final Integer getOpenProactiveInsights() {
            return this.openProactiveInsights;
        }

        public final void setOpenProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
        }

        @Override
        @Transient
        public final Builder openProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
            return this;
        }

        public final Integer getMetricsAnalyzed() {
            return this.metricsAnalyzed;
        }

        public final void setMetricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
        }

        @Override
        @Transient
        public final Builder metricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
            return this;
        }

        public final Long getResourceHours() {
            return this.resourceHours;
        }

        public final void setResourceHours(Long resourceHours) {
            this.resourceHours = resourceHours;
        }

        @Override
        @Transient
        public final Builder resourceHours(Long resourceHours) {
            this.resourceHours = resourceHours;
            return this;
        }

        @Override
        public DescribeOrganizationHealthResponse build() {
            return new DescribeOrganizationHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationHealthResponse> {
        public Builder openReactiveInsights(Integer var1);

        public Builder openProactiveInsights(Integer var1);

        public Builder metricsAnalyzed(Integer var1);

        public Builder resourceHours(Long var1);
    }
}

