/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.CostEstimationStackNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationCostEstimationResourceCollectionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationCostEstimationResourceCollectionFilter> {
    private static final SdkField<List<String>> STACK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackNames").getter(CloudFormationCostEstimationResourceCollectionFilter.getter(CloudFormationCostEstimationResourceCollectionFilter::stackNames)).setter(CloudFormationCostEstimationResourceCollectionFilter.setter(Builder::stackNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> stackNames;

    private CloudFormationCostEstimationResourceCollectionFilter(BuilderImpl builder) {
        this.stackNames = builder.stackNames;
    }

    public final boolean hasStackNames() {
        return this.stackNames != null && !(this.stackNames instanceof SdkAutoConstructList);
    }

    public final List<String> stackNames() {
        return this.stackNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackNames() ? this.stackNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationCostEstimationResourceCollectionFilter)) {
            return false;
        }
        CloudFormationCostEstimationResourceCollectionFilter other = (CloudFormationCostEstimationResourceCollectionFilter)obj;
        return this.hasStackNames() == other.hasStackNames() && Objects.equals(this.stackNames(), other.stackNames());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationCostEstimationResourceCollectionFilter").add("StackNames", this.hasStackNames() ? this.stackNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackNames": {
                return Optional.ofNullable(clazz.cast(this.stackNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationCostEstimationResourceCollectionFilter, T> g) {
        return obj -> g.apply((CloudFormationCostEstimationResourceCollectionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stackNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationCostEstimationResourceCollectionFilter model) {
            this.stackNames(model.stackNames);
        }

        public final Collection<String> getStackNames() {
            if (this.stackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackNames;
        }

        @Override
        public final Builder stackNames(Collection<String> stackNames) {
            this.stackNames = CostEstimationStackNamesCopier.copy(stackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackNames(String ... stackNames) {
            this.stackNames(Arrays.asList(stackNames));
            return this;
        }

        public final void setStackNames(Collection<String> stackNames) {
            this.stackNames = CostEstimationStackNamesCopier.copy(stackNames);
        }

        public CloudFormationCostEstimationResourceCollectionFilter build() {
            return new CloudFormationCostEstimationResourceCollectionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationCostEstimationResourceCollectionFilter> {
        public Builder stackNames(Collection<String> var1);

        public Builder stackNames(String ... var1);
    }
}

