/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ServiceName {
    API_GATEWAY("API_GATEWAY"),
    APPLICATION_ELB("APPLICATION_ELB"),
    AUTO_SCALING_GROUP("AUTO_SCALING_GROUP"),
    CLOUD_FRONT("CLOUD_FRONT"),
    DYNAMO_DB("DYNAMO_DB"),
    EC2("EC2"),
    ECS("ECS"),
    EKS("EKS"),
    ELASTIC_BEANSTALK("ELASTIC_BEANSTALK"),
    ELASTI_CACHE("ELASTI_CACHE"),
    ELB("ELB"),
    ES("ES"),
    KINESIS("KINESIS"),
    LAMBDA("LAMBDA"),
    NAT_GATEWAY("NAT_GATEWAY"),
    NETWORK_ELB("NETWORK_ELB"),
    RDS("RDS"),
    REDSHIFT("REDSHIFT"),
    ROUTE_53("ROUTE_53"),
    S3("S3"),
    SAGE_MAKER("SAGE_MAKER"),
    SNS("SNS"),
    SQS("SQS"),
    STEP_FUNCTIONS("STEP_FUNCTIONS"),
    SWF("SWF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ServiceName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ServiceName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceName> knownValues() {
        return Stream.of(ServiceName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

