/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountHealthResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeAccountHealthResponse> {
    private static final SdkField<Integer> OPEN_REACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OpenReactiveInsights").getter(DescribeAccountHealthResponse.getter(DescribeAccountHealthResponse::openReactiveInsights)).setter(DescribeAccountHealthResponse.setter(Builder::openReactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenReactiveInsights").build()}).build();
    private static final SdkField<Integer> OPEN_PROACTIVE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OpenProactiveInsights").getter(DescribeAccountHealthResponse.getter(DescribeAccountHealthResponse::openProactiveInsights)).setter(DescribeAccountHealthResponse.setter(Builder::openProactiveInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenProactiveInsights").build()}).build();
    private static final SdkField<Integer> METRICS_ANALYZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MetricsAnalyzed").getter(DescribeAccountHealthResponse.getter(DescribeAccountHealthResponse::metricsAnalyzed)).setter(DescribeAccountHealthResponse.setter(Builder::metricsAnalyzed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsAnalyzed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPEN_REACTIVE_INSIGHTS_FIELD, OPEN_PROACTIVE_INSIGHTS_FIELD, METRICS_ANALYZED_FIELD));
    private final Integer openReactiveInsights;
    private final Integer openProactiveInsights;
    private final Integer metricsAnalyzed;

    private DescribeAccountHealthResponse(BuilderImpl builder) {
        super(builder);
        this.openReactiveInsights = builder.openReactiveInsights;
        this.openProactiveInsights = builder.openProactiveInsights;
        this.metricsAnalyzed = builder.metricsAnalyzed;
    }

    public final Integer openReactiveInsights() {
        return this.openReactiveInsights;
    }

    public final Integer openProactiveInsights() {
        return this.openProactiveInsights;
    }

    public final Integer metricsAnalyzed() {
        return this.metricsAnalyzed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.openReactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.openProactiveInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsAnalyzed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountHealthResponse)) {
            return false;
        }
        DescribeAccountHealthResponse other = (DescribeAccountHealthResponse)((Object)obj);
        return Objects.equals(this.openReactiveInsights(), other.openReactiveInsights()) && Objects.equals(this.openProactiveInsights(), other.openProactiveInsights()) && Objects.equals(this.metricsAnalyzed(), other.metricsAnalyzed());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountHealthResponse").add("OpenReactiveInsights", (Object)this.openReactiveInsights()).add("OpenProactiveInsights", (Object)this.openProactiveInsights()).add("MetricsAnalyzed", (Object)this.metricsAnalyzed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpenReactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.openReactiveInsights()));
            }
            case "OpenProactiveInsights": {
                return Optional.ofNullable(clazz.cast(this.openProactiveInsights()));
            }
            case "MetricsAnalyzed": {
                return Optional.ofNullable(clazz.cast(this.metricsAnalyzed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountHealthResponse, T> g) {
        return obj -> g.apply((DescribeAccountHealthResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private Integer openReactiveInsights;
        private Integer openProactiveInsights;
        private Integer metricsAnalyzed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountHealthResponse model) {
            super(model);
            this.openReactiveInsights(model.openReactiveInsights);
            this.openProactiveInsights(model.openProactiveInsights);
            this.metricsAnalyzed(model.metricsAnalyzed);
        }

        public final Integer getOpenReactiveInsights() {
            return this.openReactiveInsights;
        }

        @Override
        public final Builder openReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
            return this;
        }

        public final void setOpenReactiveInsights(Integer openReactiveInsights) {
            this.openReactiveInsights = openReactiveInsights;
        }

        public final Integer getOpenProactiveInsights() {
            return this.openProactiveInsights;
        }

        @Override
        public final Builder openProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
            return this;
        }

        public final void setOpenProactiveInsights(Integer openProactiveInsights) {
            this.openProactiveInsights = openProactiveInsights;
        }

        public final Integer getMetricsAnalyzed() {
            return this.metricsAnalyzed;
        }

        @Override
        public final Builder metricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
            return this;
        }

        public final void setMetricsAnalyzed(Integer metricsAnalyzed) {
            this.metricsAnalyzed = metricsAnalyzed;
        }

        @Override
        public DescribeAccountHealthResponse build() {
            return new DescribeAccountHealthResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountHealthResponse> {
        public Builder openReactiveInsights(Integer var1);

        public Builder openProactiveInsights(Integer var1);

        public Builder metricsAnalyzed(Integer var1);
    }
}

