/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.EventClass;
import software.amazon.awssdk.services.devopsguru.model.EventDataSource;
import software.amazon.awssdk.services.devopsguru.model.EventTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEventsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListEventsFilters> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(ListEventsFilters.getter(ListEventsFilters::dataSourceAsString)).setter(ListEventsFilters.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> EVENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventClass").getter(ListEventsFilters.getter(ListEventsFilters::eventClassAsString)).setter(ListEventsFilters.setter(Builder::eventClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventClass").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(ListEventsFilters.getter(ListEventsFilters::eventSource)).setter(ListEventsFilters.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<EventTimeRange> EVENT_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventTimeRange").getter(ListEventsFilters.getter(ListEventsFilters::eventTimeRange)).setter(ListEventsFilters.setter(Builder::eventTimeRange)).constructor(EventTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeRange").build()}).build();
    private static final SdkField<String> INSIGHT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightId").getter(ListEventsFilters.getter(ListEventsFilters::insightId)).setter(ListEventsFilters.setter(Builder::insightId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightId").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ListEventsFilters.getter(ListEventsFilters::resourceCollection)).setter(ListEventsFilters.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, EVENT_CLASS_FIELD, EVENT_SOURCE_FIELD, EVENT_TIME_RANGE_FIELD, INSIGHT_ID_FIELD, RESOURCE_COLLECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final String eventClass;
    private final String eventSource;
    private final EventTimeRange eventTimeRange;
    private final String insightId;
    private final ResourceCollection resourceCollection;

    private ListEventsFilters(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.eventClass = builder.eventClass;
        this.eventSource = builder.eventSource;
        this.eventTimeRange = builder.eventTimeRange;
        this.insightId = builder.insightId;
        this.resourceCollection = builder.resourceCollection;
    }

    public EventDataSource dataSource() {
        return EventDataSource.fromValue(this.dataSource);
    }

    public String dataSourceAsString() {
        return this.dataSource;
    }

    public EventClass eventClass() {
        return EventClass.fromValue(this.eventClass);
    }

    public String eventClassAsString() {
        return this.eventClass;
    }

    public String eventSource() {
        return this.eventSource;
    }

    public EventTimeRange eventTimeRange() {
        return this.eventTimeRange;
    }

    public String insightId() {
        return this.insightId;
    }

    public ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventsFilters)) {
            return false;
        }
        ListEventsFilters other = (ListEventsFilters)obj;
        return Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.eventClassAsString(), other.eventClassAsString()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.eventTimeRange(), other.eventTimeRange()) && Objects.equals(this.insightId(), other.insightId()) && Objects.equals(this.resourceCollection(), other.resourceCollection());
    }

    public String toString() {
        return ToString.builder((String)"ListEventsFilters").add("DataSource", (Object)this.dataSourceAsString()).add("EventClass", (Object)this.eventClassAsString()).add("EventSource", (Object)this.eventSource()).add("EventTimeRange", (Object)this.eventTimeRange()).add("InsightId", (Object)this.insightId()).add("ResourceCollection", (Object)this.resourceCollection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "EventClass": {
                return Optional.ofNullable(clazz.cast(this.eventClassAsString()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "EventTimeRange": {
                return Optional.ofNullable(clazz.cast(this.eventTimeRange()));
            }
            case "InsightId": {
                return Optional.ofNullable(clazz.cast(this.insightId()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventsFilters, T> g) {
        return obj -> g.apply((ListEventsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private String eventClass;
        private String eventSource;
        private EventTimeRange eventTimeRange;
        private String insightId;
        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventsFilters model) {
            this.dataSource(model.dataSource);
            this.eventClass(model.eventClass);
            this.eventSource(model.eventSource);
            this.eventTimeRange(model.eventTimeRange);
            this.insightId(model.insightId);
            this.resourceCollection(model.resourceCollection);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(EventDataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getEventClass() {
            return this.eventClass;
        }

        @Override
        public final Builder eventClass(String eventClass) {
            this.eventClass = eventClass;
            return this;
        }

        @Override
        public final Builder eventClass(EventClass eventClass) {
            this.eventClass(eventClass == null ? null : eventClass.toString());
            return this;
        }

        public final void setEventClass(String eventClass) {
            this.eventClass = eventClass;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public final EventTimeRange.Builder getEventTimeRange() {
            return this.eventTimeRange != null ? this.eventTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder eventTimeRange(EventTimeRange eventTimeRange) {
            this.eventTimeRange = eventTimeRange;
            return this;
        }

        public final void setEventTimeRange(EventTimeRange.BuilderImpl eventTimeRange) {
            this.eventTimeRange = eventTimeRange != null ? eventTimeRange.build() : null;
        }

        public final String getInsightId() {
            return this.insightId;
        }

        @Override
        public final Builder insightId(String insightId) {
            this.insightId = insightId;
            return this;
        }

        public final void setInsightId(String insightId) {
            this.insightId = insightId;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public ListEventsFilters build() {
            return new ListEventsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListEventsFilters> {
        public Builder dataSource(String var1);

        public Builder dataSource(EventDataSource var1);

        public Builder eventClass(String var1);

        public Builder eventClass(EventClass var1);

        public Builder eventSource(String var1);

        public Builder eventTimeRange(EventTimeRange var1);

        default public Builder eventTimeRange(Consumer<EventTimeRange.Builder> eventTimeRange) {
            return this.eventTimeRange((EventTimeRange)((EventTimeRange.Builder)EventTimeRange.builder().applyMutation(eventTimeRange)).build());
        }

        public Builder insightId(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }
    }
}

