/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.InsightSeverity;
import software.amazon.awssdk.services.devopsguru.model.InsightStatus;
import software.amazon.awssdk.services.devopsguru.model.InsightTimeRange;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReactiveInsightSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReactiveInsightSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::id)).setter(ReactiveInsightSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InsightTimeRange").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::insightTimeRange)).setter(ReactiveInsightSummary.setter(Builder::insightTimeRange)).constructor(InsightTimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::name)).setter(ReactiveInsightSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::resourceCollection)).setter(ReactiveInsightSummary.setter(Builder::resourceCollection)).constructor(ResourceCollection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::severityAsString)).setter(ReactiveInsightSummary.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReactiveInsightSummary.getter(ReactiveInsightSummary::statusAsString)).setter(ReactiveInsightSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INSIGHT_TIME_RANGE_FIELD, NAME_FIELD, RESOURCE_COLLECTION_FIELD, SEVERITY_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final InsightTimeRange insightTimeRange;
    private final String name;
    private final ResourceCollection resourceCollection;
    private final String severity;
    private final String status;

    private ReactiveInsightSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.insightTimeRange = builder.insightTimeRange;
        this.name = builder.name;
        this.resourceCollection = builder.resourceCollection;
        this.severity = builder.severity;
        this.status = builder.status;
    }

    public String id() {
        return this.id;
    }

    public InsightTimeRange insightTimeRange() {
        return this.insightTimeRange;
    }

    public String name() {
        return this.name;
    }

    public ResourceCollection resourceCollection() {
        return this.resourceCollection;
    }

    public InsightSeverity severity() {
        return InsightSeverity.fromValue(this.severity);
    }

    public String severityAsString() {
        return this.severity;
    }

    public InsightStatus status() {
        return InsightStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveInsightSummary)) {
            return false;
        }
        ReactiveInsightSummary other = (ReactiveInsightSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.insightTimeRange(), other.insightTimeRange()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceCollection(), other.resourceCollection()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReactiveInsightSummary").add("Id", (Object)this.id()).add("InsightTimeRange", (Object)this.insightTimeRange()).add("Name", (Object)this.name()).add("ResourceCollection", (Object)this.resourceCollection()).add("Severity", (Object)this.severityAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InsightTimeRange": {
                return Optional.ofNullable(clazz.cast(this.insightTimeRange()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactiveInsightSummary, T> g) {
        return obj -> g.apply((ReactiveInsightSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private InsightTimeRange insightTimeRange;
        private String name;
        private ResourceCollection resourceCollection;
        private String severity;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveInsightSummary model) {
            this.id(model.id);
            this.insightTimeRange(model.insightTimeRange);
            this.name(model.name);
            this.resourceCollection(model.resourceCollection);
            this.severity(model.severity);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return this.insightTimeRange != null ? this.insightTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ReactiveInsightSummary build() {
            return new ReactiveInsightSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReactiveInsightSummary> {
        public Builder id(String var1);

        public Builder insightTimeRange(InsightTimeRange var1);

        default public Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return this.insightTimeRange((InsightTimeRange)((InsightTimeRange.Builder)InsightTimeRange.builder().applyMutation(insightTimeRange)).build());
        }

        public Builder name(String var1);

        public Builder resourceCollection(ResourceCollection var1);

        default public Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollection)((ResourceCollection.Builder)ResourceCollection.builder().applyMutation(resourceCollection)).build());
        }

        public Builder severity(String var1);

        public Builder severity(InsightSeverity var1);

        public Builder status(String var1);

        public Builder status(InsightStatus var1);
    }
}

