/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ResourceCollectionFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceCollectionResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, GetResourceCollectionResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourceCollectionResponse.getter(GetResourceCollectionResponse::nextToken)).setter(GetResourceCollectionResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<ResourceCollectionFilter> RESOURCE_COLLECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCollection").getter(GetResourceCollectionResponse.getter(GetResourceCollectionResponse::resourceCollection)).setter(GetResourceCollectionResponse.setter(Builder::resourceCollection)).constructor(ResourceCollectionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_COLLECTION_FIELD));
    private final String nextToken;
    private final ResourceCollectionFilter resourceCollection;

    private GetResourceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceCollection = builder.resourceCollection;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public ResourceCollectionFilter resourceCollection() {
        return this.resourceCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCollection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceCollectionResponse)) {
            return false;
        }
        GetResourceCollectionResponse other = (GetResourceCollectionResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.resourceCollection(), other.resourceCollection());
    }

    public String toString() {
        return ToString.builder((String)"GetResourceCollectionResponse").add("NextToken", (Object)this.nextToken()).add("ResourceCollection", (Object)this.resourceCollection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ResourceCollection": {
                return Optional.ofNullable(clazz.cast(this.resourceCollection()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceCollectionResponse, T> g) {
        return obj -> g.apply((GetResourceCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private ResourceCollectionFilter resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceCollectionResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourceCollection(model.resourceCollection);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ResourceCollectionFilter.Builder getResourceCollection() {
            return this.resourceCollection != null ? this.resourceCollection.toBuilder() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollectionFilter resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final void setResourceCollection(ResourceCollectionFilter.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public GetResourceCollectionResponse build() {
            return new GetResourceCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceCollectionResponse> {
        public Builder nextToken(String var1);

        public Builder resourceCollection(ResourceCollectionFilter var1);

        default public Builder resourceCollection(Consumer<ResourceCollectionFilter.Builder> resourceCollection) {
            return this.resourceCollection((ResourceCollectionFilter)((ResourceCollectionFilter.Builder)ResourceCollectionFilter.builder().applyMutation(resourceCollection)).build());
        }
    }
}

