/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration;
import software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDevicePoolCompatibilityRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
    private static final SdkField<String> DEVICE_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDevicePoolCompatibilityRequest.getter(GetDevicePoolCompatibilityRequest::devicePoolArn)).setter(GetDevicePoolCompatibilityRequest.setter(Builder::devicePoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePoolArn").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDevicePoolCompatibilityRequest.getter(GetDevicePoolCompatibilityRequest::appArn)).setter(GetDevicePoolCompatibilityRequest.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> TEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetDevicePoolCompatibilityRequest.getter(GetDevicePoolCompatibilityRequest::testTypeAsString)).setter(GetDevicePoolCompatibilityRequest.setter(Builder::testType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testType").build()}).build();
    private static final SdkField<ScheduleRunTest> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDevicePoolCompatibilityRequest.getter(GetDevicePoolCompatibilityRequest::test)).setter(GetDevicePoolCompatibilityRequest.setter(Builder::test)).constructor(ScheduleRunTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()}).build();
    private static final SdkField<ScheduleRunConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDevicePoolCompatibilityRequest.getter(GetDevicePoolCompatibilityRequest::configuration)).setter(GetDevicePoolCompatibilityRequest.setter(Builder::configuration)).constructor(ScheduleRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_POOL_ARN_FIELD, APP_ARN_FIELD, TEST_TYPE_FIELD, TEST_FIELD, CONFIGURATION_FIELD));
    private final String devicePoolArn;
    private final String appArn;
    private final String testType;
    private final ScheduleRunTest test;
    private final ScheduleRunConfiguration configuration;

    private GetDevicePoolCompatibilityRequest(BuilderImpl builder) {
        super(builder);
        this.devicePoolArn = builder.devicePoolArn;
        this.appArn = builder.appArn;
        this.testType = builder.testType;
        this.test = builder.test;
        this.configuration = builder.configuration;
    }

    public String devicePoolArn() {
        return this.devicePoolArn;
    }

    public String appArn() {
        return this.appArn;
    }

    public TestType testType() {
        return TestType.fromValue(this.testType);
    }

    public String testTypeAsString() {
        return this.testType;
    }

    public ScheduleRunTest test() {
        return this.test;
    }

    public ScheduleRunConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicePoolCompatibilityRequest)) {
            return false;
        }
        GetDevicePoolCompatibilityRequest other = (GetDevicePoolCompatibilityRequest)((Object)obj);
        return Objects.equals(this.devicePoolArn(), other.devicePoolArn()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.testTypeAsString(), other.testTypeAsString()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.configuration(), other.configuration());
    }

    public String toString() {
        return ToString.builder((String)"GetDevicePoolCompatibilityRequest").add("DevicePoolArn", (Object)this.devicePoolArn()).add("AppArn", (Object)this.appArn()).add("TestType", (Object)this.testTypeAsString()).add("Test", (Object)this.test()).add("Configuration", (Object)this.configuration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "devicePoolArn": {
                return Optional.ofNullable(clazz.cast(this.devicePoolArn()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "testType": {
                return Optional.ofNullable(clazz.cast(this.testTypeAsString()));
            }
            case "test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicePoolCompatibilityRequest, T> g) {
        return obj -> g.apply((GetDevicePoolCompatibilityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String devicePoolArn;
        private String appArn;
        private String testType;
        private ScheduleRunTest test;
        private ScheduleRunConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicePoolCompatibilityRequest model) {
            super(model);
            this.devicePoolArn(model.devicePoolArn);
            this.appArn(model.appArn);
            this.testType(model.testType);
            this.test(model.test);
            this.configuration(model.configuration);
        }

        public final String getDevicePoolArn() {
            return this.devicePoolArn;
        }

        @Override
        public final Builder devicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
            return this;
        }

        public final void setDevicePoolArn(String devicePoolArn) {
            this.devicePoolArn = devicePoolArn;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        public final String getTestTypeAsString() {
            return this.testType;
        }

        @Override
        public final Builder testType(String testType) {
            this.testType = testType;
            return this;
        }

        @Override
        public final Builder testType(TestType testType) {
            this.testType(testType.toString());
            return this;
        }

        public final void setTestType(String testType) {
            this.testType = testType;
        }

        public final ScheduleRunTest.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(ScheduleRunTest test) {
            this.test = test;
            return this;
        }

        public final void setTest(ScheduleRunTest.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public final ScheduleRunConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ScheduleRunConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ScheduleRunConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDevicePoolCompatibilityRequest build() {
            return new GetDevicePoolCompatibilityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDevicePoolCompatibilityRequest> {
        public Builder devicePoolArn(String var1);

        public Builder appArn(String var1);

        public Builder testType(String var1);

        public Builder testType(TestType var1);

        public Builder test(ScheduleRunTest var1);

        default public Builder test(Consumer<ScheduleRunTest.Builder> test) {
            return this.test((ScheduleRunTest)((ScheduleRunTest.Builder)ScheduleRunTest.builder().applyMutation(test)).build());
        }

        public Builder configuration(ScheduleRunConfiguration var1);

        default public Builder configuration(Consumer<ScheduleRunConfiguration.Builder> configuration) {
            return this.configuration((ScheduleRunConfiguration)((ScheduleRunConfiguration.Builder)ScheduleRunConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

