/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.AmazonResourceNamesCopier;
import software.amazon.awssdk.services.devicefarm.model.BillingMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRemoteAccessSessionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
    private static final SdkField<String> BILLING_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateRemoteAccessSessionConfiguration.getter(CreateRemoteAccessSessionConfiguration::billingMethodAsString)).setter(CreateRemoteAccessSessionConfiguration.setter(Builder::billingMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingMethod").build()}).build();
    private static final SdkField<List<String>> VPCE_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateRemoteAccessSessionConfiguration.getter(CreateRemoteAccessSessionConfiguration::vpceConfigurationArns)).setter(CreateRemoteAccessSessionConfiguration.setter(Builder::vpceConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpceConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_METHOD_FIELD, VPCE_CONFIGURATION_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String billingMethod;
    private final List<String> vpceConfigurationArns;

    private CreateRemoteAccessSessionConfiguration(BuilderImpl builder) {
        this.billingMethod = builder.billingMethod;
        this.vpceConfigurationArns = builder.vpceConfigurationArns;
    }

    public BillingMethod billingMethod() {
        return BillingMethod.fromValue(this.billingMethod);
    }

    public String billingMethodAsString() {
        return this.billingMethod;
    }

    public List<String> vpceConfigurationArns() {
        return this.vpceConfigurationArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.billingMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceConfigurationArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionConfiguration)) {
            return false;
        }
        CreateRemoteAccessSessionConfiguration other = (CreateRemoteAccessSessionConfiguration)obj;
        return Objects.equals(this.billingMethodAsString(), other.billingMethodAsString()) && Objects.equals(this.vpceConfigurationArns(), other.vpceConfigurationArns());
    }

    public String toString() {
        return ToString.builder((String)"CreateRemoteAccessSessionConfiguration").add("BillingMethod", (Object)this.billingMethodAsString()).add("VpceConfigurationArns", this.vpceConfigurationArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingMethod": {
                return Optional.ofNullable(clazz.cast(this.billingMethodAsString()));
            }
            case "vpceConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.vpceConfigurationArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRemoteAccessSessionConfiguration, T> g) {
        return obj -> g.apply((CreateRemoteAccessSessionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String billingMethod;
        private List<String> vpceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionConfiguration model) {
            this.billingMethod(model.billingMethod);
            this.vpceConfigurationArns(model.vpceConfigurationArns);
        }

        public final String getBillingMethodAsString() {
            return this.billingMethod;
        }

        @Override
        public final Builder billingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
            return this;
        }

        @Override
        public final Builder billingMethod(BillingMethod billingMethod) {
            this.billingMethod(billingMethod.toString());
            return this;
        }

        public final void setBillingMethod(String billingMethod) {
            this.billingMethod = billingMethod;
        }

        public final Collection<String> getVpceConfigurationArns() {
            return this.vpceConfigurationArns;
        }

        @Override
        public final Builder vpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpceConfigurationArns(String ... vpceConfigurationArns) {
            this.vpceConfigurationArns(Arrays.asList(vpceConfigurationArns));
            return this;
        }

        public final void setVpceConfigurationArns(Collection<String> vpceConfigurationArns) {
            this.vpceConfigurationArns = AmazonResourceNamesCopier.copy(vpceConfigurationArns);
        }

        public CreateRemoteAccessSessionConfiguration build() {
            return new CreateRemoteAccessSessionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateRemoteAccessSessionConfiguration> {
        public Builder billingMethod(String var1);

        public Builder billingMethod(BillingMethod var1);

        public Builder vpceConfigurationArns(Collection<String> var1);

        public Builder vpceConfigurationArns(String ... var1);
    }
}

