/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.services.devicefarm.model.RecurringChargeFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecurringCharge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecurringCharge> {
    private static final SdkField<MonetaryAmount> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RecurringCharge.getter(RecurringCharge::cost)).setter(RecurringCharge.setter(Builder::cost)).constructor(MonetaryAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecurringCharge.getter(RecurringCharge::frequencyAsString)).setter(RecurringCharge.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_FIELD, FREQUENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final MonetaryAmount cost;
    private final String frequency;

    private RecurringCharge(BuilderImpl builder) {
        this.cost = builder.cost;
        this.frequency = builder.frequency;
    }

    public MonetaryAmount cost() {
        return this.cost;
    }

    public RecurringChargeFrequency frequency() {
        return RecurringChargeFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        return Objects.equals(this.cost(), other.cost()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString());
    }

    public String toString() {
        return ToString.builder((String)"RecurringCharge").add("Cost", (Object)this.cost()).add("Frequency", (Object)this.frequencyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecurringCharge, T> g) {
        return obj -> g.apply((RecurringCharge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonetaryAmount cost;
        private String frequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            this.cost(model.cost);
            this.frequency(model.frequency);
        }

        public final MonetaryAmount.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        @Override
        public final Builder cost(MonetaryAmount cost) {
            this.cost = cost;
            return this;
        }

        public final void setCost(MonetaryAmount.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        public final String getFrequencyAsString() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(RecurringChargeFrequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public RecurringCharge build() {
            return new RecurringCharge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecurringCharge> {
        public Builder cost(MonetaryAmount var1);

        default public Builder cost(Consumer<MonetaryAmount.Builder> cost) {
            return this.cost((MonetaryAmount)((MonetaryAmount.Builder)MonetaryAmount.builder().applyMutation(cost)).build());
        }

        public Builder frequency(String var1);

        public Builder frequency(RecurringChargeFrequency var1);
    }
}

