/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.devicefarm.model.TestParametersCopier;
import software.amazon.awssdk.services.devicefarm.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduleRunTest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduleRunTest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ScheduleRunTest.getter(ScheduleRunTest::typeAsString)).setter(ScheduleRunTest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TEST_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testPackageArn").getter(ScheduleRunTest.getter(ScheduleRunTest::testPackageArn)).setter(ScheduleRunTest.setter(Builder::testPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testPackageArn").build()}).build();
    private static final SdkField<String> TEST_SPEC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSpecArn").getter(ScheduleRunTest.getter(ScheduleRunTest::testSpecArn)).setter(ScheduleRunTest.setter(Builder::testSpecArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSpecArn").build()}).build();
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filter").getter(ScheduleRunTest.getter(ScheduleRunTest::filter)).setter(ScheduleRunTest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(ScheduleRunTest.getter(ScheduleRunTest::parameters)).setter(ScheduleRunTest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TEST_PACKAGE_ARN_FIELD, TEST_SPEC_ARN_FIELD, FILTER_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduleRunTest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String testPackageArn;
    private final String testSpecArn;
    private final String filter;
    private final Map<String, String> parameters;

    private ScheduleRunTest(BuilderImpl builder) {
        this.type = builder.type;
        this.testPackageArn = builder.testPackageArn;
        this.testSpecArn = builder.testSpecArn;
        this.filter = builder.filter;
        this.parameters = builder.parameters;
    }

    public final TestType type() {
        return TestType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String testPackageArn() {
        return this.testPackageArn;
    }

    public final String testSpecArn() {
        return this.testSpecArn;
    }

    public final String filter() {
        return this.filter;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.testPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSpecArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleRunTest)) {
            return false;
        }
        ScheduleRunTest other = (ScheduleRunTest)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.testPackageArn(), other.testPackageArn()) && Objects.equals(this.testSpecArn(), other.testSpecArn()) && Objects.equals(this.filter(), other.filter()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduleRunTest").add("Type", (Object)this.typeAsString()).add("TestPackageArn", (Object)this.testPackageArn()).add("TestSpecArn", (Object)this.testSpecArn()).add("Filter", (Object)this.filter()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "testPackageArn": {
                return Optional.ofNullable(clazz.cast(this.testPackageArn()));
            }
            case "testSpecArn": {
                return Optional.ofNullable(clazz.cast(this.testSpecArn()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("testPackageArn", TEST_PACKAGE_ARN_FIELD);
        map.put("testSpecArn", TEST_SPEC_ARN_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduleRunTest, T> g) {
        return obj -> g.apply((ScheduleRunTest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String testPackageArn;
        private String testSpecArn;
        private String filter;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleRunTest model) {
            this.type(model.type);
            this.testPackageArn(model.testPackageArn);
            this.testSpecArn(model.testSpecArn);
            this.filter(model.filter);
            this.parameters(model.parameters);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTestPackageArn() {
            return this.testPackageArn;
        }

        public final void setTestPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
        }

        @Override
        public final Builder testPackageArn(String testPackageArn) {
            this.testPackageArn = testPackageArn;
            return this;
        }

        public final String getTestSpecArn() {
            return this.testSpecArn;
        }

        public final void setTestSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
        }

        @Override
        public final Builder testSpecArn(String testSpecArn) {
            this.testSpecArn = testSpecArn;
            return this;
        }

        public final String getFilter() {
            return this.filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = TestParametersCopier.copy(parameters);
            return this;
        }

        public ScheduleRunTest build() {
            return new ScheduleRunTest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduleRunTest> {
        public Builder type(String var1);

        public Builder type(TestType var1);

        public Builder testPackageArn(String var1);

        public Builder testSpecArn(String var1);

        public Builder filter(String var1);

        public Builder parameters(Map<String, String> var1);
    }
}

