/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestGridSessionArtifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestGridSessionArtifact> {
    private static final SdkField<String> FILENAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filename").getter(TestGridSessionArtifact.getter(TestGridSessionArtifact::filename)).setter(TestGridSessionArtifact.setter(Builder::filename)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filename").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TestGridSessionArtifact.getter(TestGridSessionArtifact::typeAsString)).setter(TestGridSessionArtifact.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(TestGridSessionArtifact.getter(TestGridSessionArtifact::url)).setter(TestGridSessionArtifact.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILENAME_FIELD, TYPE_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestGridSessionArtifact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filename;
    private final String type;
    private final String url;

    private TestGridSessionArtifact(BuilderImpl builder) {
        this.filename = builder.filename;
        this.type = builder.type;
        this.url = builder.url;
    }

    public final String filename() {
        return this.filename;
    }

    public final TestGridSessionArtifactType type() {
        return TestGridSessionArtifactType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filename());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSessionArtifact)) {
            return false;
        }
        TestGridSessionArtifact other = (TestGridSessionArtifact)obj;
        return Objects.equals(this.filename(), other.filename()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"TestGridSessionArtifact").add("Filename", (Object)this.filename()).add("Type", (Object)this.typeAsString()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filename": {
                return Optional.ofNullable(clazz.cast(this.filename()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("filename", FILENAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestGridSessionArtifact, T> g) {
        return obj -> g.apply((TestGridSessionArtifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filename;
        private String type;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSessionArtifact model) {
            this.filename(model.filename);
            this.type(model.type);
            this.url(model.url);
        }

        public final String getFilename() {
            return this.filename;
        }

        public final void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public final Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestGridSessionArtifactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public TestGridSessionArtifact build() {
            return new TestGridSessionArtifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestGridSessionArtifact> {
        public Builder filename(String var1);

        public Builder type(String var1);

        public Builder type(TestGridSessionArtifactType var1);

        public Builder url(String var1);
    }
}

