/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TestType {
    BUILTIN_FUZZ("BUILTIN_FUZZ"),
    BUILTIN_EXPLORER("BUILTIN_EXPLORER"),
    WEB_PERFORMANCE_PROFILE("WEB_PERFORMANCE_PROFILE"),
    APPIUM_JAVA_JUNIT("APPIUM_JAVA_JUNIT"),
    APPIUM_JAVA_TESTNG("APPIUM_JAVA_TESTNG"),
    APPIUM_PYTHON("APPIUM_PYTHON"),
    APPIUM_NODE("APPIUM_NODE"),
    APPIUM_RUBY("APPIUM_RUBY"),
    APPIUM_WEB_JAVA_JUNIT("APPIUM_WEB_JAVA_JUNIT"),
    APPIUM_WEB_JAVA_TESTNG("APPIUM_WEB_JAVA_TESTNG"),
    APPIUM_WEB_PYTHON("APPIUM_WEB_PYTHON"),
    APPIUM_WEB_NODE("APPIUM_WEB_NODE"),
    APPIUM_WEB_RUBY("APPIUM_WEB_RUBY"),
    CALABASH("CALABASH"),
    INSTRUMENTATION("INSTRUMENTATION"),
    UIAUTOMATION("UIAUTOMATION"),
    UIAUTOMATOR("UIAUTOMATOR"),
    XCTEST("XCTEST"),
    XCTEST_UI("XCTEST_UI"),
    REMOTE_ACCESS_RECORD("REMOTE_ACCESS_RECORD"),
    REMOTE_ACCESS_REPLAY("REMOTE_ACCESS_REPLAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TestType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TestType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestType> knownValues() {
        return Stream.of(TestType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

