/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.Job;
import software.amazon.awssdk.services.devicefarm.model.ListJobsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListJobsResponse;

public class ListJobsPublisher
implements SdkPublisher<ListJobsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsPublisher(DeviceFarmAsyncClient client, ListJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsPublisher(DeviceFarmAsyncClient client, ListJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Job> jobs() {
        Function<ListJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobsResponseFetcher
    implements AsyncPageFetcher<ListJobsResponse> {
        private ListJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobsResponse> nextPage(ListJobsResponse previousPage) {
            if (previousPage == null) {
                return ListJobsPublisher.this.client.listJobs(ListJobsPublisher.this.firstRequest);
            }
            return ListJobsPublisher.this.client.listJobs((ListJobsRequest)((Object)ListJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

