/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListUploadsResponse;
import software.amazon.awssdk.services.devicefarm.model.Upload;

public class ListUploadsPublisher
implements SdkPublisher<ListUploadsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListUploadsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUploadsPublisher(DeviceFarmAsyncClient client, ListUploadsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUploadsPublisher(DeviceFarmAsyncClient client, ListUploadsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUploadsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUploadsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Upload> uploads() {
        Function<ListUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUploadsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUploadsResponseFetcher
    implements AsyncPageFetcher<ListUploadsResponse> {
        private ListUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUploadsResponse> nextPage(ListUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadsPublisher.this.client.listUploads(ListUploadsPublisher.this.firstRequest);
            }
            return ListUploadsPublisher.this.client.listUploads((ListUploadsRequest)((Object)ListUploadsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

