/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SampleType {
    CPU("CPU"),
    MEMORY("MEMORY"),
    THREADS("THREADS"),
    RX_RATE("RX_RATE"),
    TX_RATE("TX_RATE"),
    RX("RX"),
    TX("TX"),
    NATIVE_FRAMES("NATIVE_FRAMES"),
    NATIVE_FPS("NATIVE_FPS"),
    NATIVE_MIN_DRAWTIME("NATIVE_MIN_DRAWTIME"),
    NATIVE_AVG_DRAWTIME("NATIVE_AVG_DRAWTIME"),
    NATIVE_MAX_DRAWTIME("NATIVE_MAX_DRAWTIME"),
    OPENGL_FRAMES("OPENGL_FRAMES"),
    OPENGL_FPS("OPENGL_FPS"),
    OPENGL_MIN_DRAWTIME("OPENGL_MIN_DRAWTIME"),
    OPENGL_AVG_DRAWTIME("OPENGL_AVG_DRAWTIME"),
    OPENGL_MAX_DRAWTIME("OPENGL_MAX_DRAWTIME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SampleType> VALUE_MAP;
    private final String value;

    private SampleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SampleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SampleType> knownValues() {
        EnumSet<SampleType> knownValues = EnumSet.allOf(SampleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SampleType.class, SampleType::toString);
    }
}

