/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.Run;

public class ListRunsIterable
implements SdkIterable<ListRunsResponse> {
    private final DeviceFarmClient client;
    private final ListRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRunsIterable(DeviceFarmClient client, ListRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRunsResponseFetcher();
    }

    public Iterator<ListRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Run> runs() {
        Function<ListRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.runs() != null) {
                return response.runs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRunsResponseFetcher
    implements SyncPageFetcher<ListRunsResponse> {
        private ListRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRunsResponse nextPage(ListRunsResponse previousPage) {
            if (previousPage == null) {
                return ListRunsIterable.this.client.listRuns(ListRunsIterable.this.firstRequest);
            }
            return ListRunsIterable.this.client.listRuns((ListRunsRequest)((Object)ListRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

