/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Job implements SdkPojo, Serializable, ToCopyableBuilder<Job.Builder, Job> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Job::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Job::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Job::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(Job::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Job::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("result")
            .getter(getter(Job::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<Instant> STARTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("started").getter(getter(Job::started)).setter(setter(Builder::started))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()).build();

    private static final SdkField<Instant> STOPPED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("stopped").getter(getter(Job::stopped)).setter(setter(Builder::stopped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopped").build()).build();

    private static final SdkField<Counters> COUNTERS_FIELD = SdkField.<Counters> builder(MarshallingType.SDK_POJO)
            .memberName("counters").getter(getter(Job::counters)).setter(setter(Builder::counters))
            .constructor(Counters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counters").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(Job::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Device> DEVICE_FIELD = SdkField.<Device> builder(MarshallingType.SDK_POJO).memberName("device")
            .getter(getter(Job::device)).setter(setter(Builder::device)).constructor(Device::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("device").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(Job::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<DeviceMinutes> DEVICE_MINUTES_FIELD = SdkField
            .<DeviceMinutes> builder(MarshallingType.SDK_POJO).memberName("deviceMinutes").getter(getter(Job::deviceMinutes))
            .setter(setter(Builder::deviceMinutes)).constructor(DeviceMinutes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMinutes").build()).build();

    private static final SdkField<String> VIDEO_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("videoEndpoint").getter(getter(Job::videoEndpoint)).setter(setter(Builder::videoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoEndpoint").build()).build();

    private static final SdkField<Boolean> VIDEO_CAPTURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("videoCapture").getter(getter(Job::videoCapture)).setter(setter(Builder::videoCapture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCapture").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            TYPE_FIELD, CREATED_FIELD, STATUS_FIELD, RESULT_FIELD, STARTED_FIELD, STOPPED_FIELD, COUNTERS_FIELD, MESSAGE_FIELD,
            DEVICE_FIELD, INSTANCE_ARN_FIELD, DEVICE_MINUTES_FIELD, VIDEO_ENDPOINT_FIELD, VIDEO_CAPTURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String type;

    private final Instant created;

    private final String status;

    private final String result;

    private final Instant started;

    private final Instant stopped;

    private final Counters counters;

    private final String message;

    private final Device device;

    private final String instanceArn;

    private final DeviceMinutes deviceMinutes;

    private final String videoEndpoint;

    private final Boolean videoCapture;

    private Job(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.created = builder.created;
        this.status = builder.status;
        this.result = builder.result;
        this.started = builder.started;
        this.stopped = builder.stopped;
        this.counters = builder.counters;
        this.message = builder.message;
        this.device = builder.device;
        this.instanceArn = builder.instanceArn;
        this.deviceMinutes = builder.deviceMinutes;
        this.videoEndpoint = builder.videoEndpoint;
        this.videoCapture = builder.videoCapture;
    }

    /**
     * <p>
     * The job's ARN.
     * </p>
     * 
     * @return The job's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The job's name.
     * </p>
     * 
     * @return The job's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI
     *         </p>
     *         </li>
     * @see TestType
     */
    public final TestType type() {
        return TestType.fromValue(type);
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * Allowed values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * BUILTIN_FUZZ
     * </p>
     * </li>
     * <li>
     * <p>
     * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing
     * screenshots at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_JUNIT
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_JAVA_TESTNG
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_PYTHON
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_NODE
     * </p>
     * </li>
     * <li>
     * <p>
     * APPIUM_WEB_RUBY
     * </p>
     * </li>
     * <li>
     * <p>
     * CALABASH
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTRUMENTATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATION
     * </p>
     * </li>
     * <li>
     * <p>
     * UIAUTOMATOR
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST
     * </p>
     * </li>
     * <li>
     * <p>
     * XCTEST_UI
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The job's type.</p>
     *         <p>
     *         Allowed values include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         BUILTIN_FUZZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
     *         capturing screenshots at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_JUNIT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_JAVA_TESTNG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_PYTHON
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_NODE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         APPIUM_WEB_RUBY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CALABASH
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTRUMENTATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UIAUTOMATOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         XCTEST_UI
     *         </p>
     *         </li>
     * @see TestType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_CONCURRENCY
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING_DEVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING
     * </p>
     * </li>
     * <li>
     * <p>
     * SCHEDULING
     * </p>
     * </li>
     * <li>
     * <p>
     * PREPARING
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPING
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_CONCURRENCY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING_DEVICE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCHEDULING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PREPARING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPING
     *         </p>
     *         </li>
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The job's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The job's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final ExecutionResult result() {
        return ExecutionResult.fromValue(result);
    }

    /**
     * <p>
     * The job's result.
     * </p>
     * <p>
     * Allowed values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PENDING
     * </p>
     * </li>
     * <li>
     * <p>
     * PASSED
     * </p>
     * </li>
     * <li>
     * <p>
     * WARNED
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED
     * </p>
     * </li>
     * <li>
     * <p>
     * ERRORED
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link ExecutionResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The job's result.</p>
     *         <p>
     *         Allowed values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PENDING
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PASSED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         WARNED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ERRORED
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED
     *         </p>
     *         </li>
     * @see ExecutionResult
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * The job's start time.
     * </p>
     * 
     * @return The job's start time.
     */
    public final Instant started() {
        return started;
    }

    /**
     * <p>
     * The job's stop time.
     * </p>
     * 
     * @return The job's stop time.
     */
    public final Instant stopped() {
        return stopped;
    }

    /**
     * <p>
     * The job's result counters.
     * </p>
     * 
     * @return The job's result counters.
     */
    public final Counters counters() {
        return counters;
    }

    /**
     * <p>
     * A message about the job's result.
     * </p>
     * 
     * @return A message about the job's result.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The device (phone or tablet).
     * </p>
     * 
     * @return The device (phone or tablet).
     */
    public final Device device() {
        return device;
    }

    /**
     * <p>
     * The ARN of the instance.
     * </p>
     * 
     * @return The ARN of the instance.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * Represents the total (metered or unmetered) minutes used by the job.
     * </p>
     * 
     * @return Represents the total (metered or unmetered) minutes used by the job.
     */
    public final DeviceMinutes deviceMinutes() {
        return deviceMinutes;
    }

    /**
     * <p>
     * The endpoint for streaming device video.
     * </p>
     * 
     * @return The endpoint for streaming device video.
     */
    public final String videoEndpoint() {
        return videoEndpoint;
    }

    /**
     * <p>
     * This value is set to true if video capture is enabled. Otherwise, it is set to false.
     * </p>
     * 
     * @return This value is set to true if video capture is enabled. Otherwise, it is set to false.
     */
    public final Boolean videoCapture() {
        return videoCapture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(started());
        hashCode = 31 * hashCode + Objects.hashCode(stopped());
        hashCode = 31 * hashCode + Objects.hashCode(counters());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(videoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(videoCapture());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultAsString(), other.resultAsString()) && Objects.equals(started(), other.started())
                && Objects.equals(stopped(), other.stopped()) && Objects.equals(counters(), other.counters())
                && Objects.equals(message(), other.message()) && Objects.equals(device(), other.device())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(deviceMinutes(), other.deviceMinutes())
                && Objects.equals(videoEndpoint(), other.videoEndpoint()) && Objects.equals(videoCapture(), other.videoCapture());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Job").add("Arn", arn()).add("Name", name()).add("Type", typeAsString())
                .add("Created", created()).add("Status", statusAsString()).add("Result", resultAsString())
                .add("Started", started()).add("Stopped", stopped()).add("Counters", counters()).add("Message", message())
                .add("Device", device()).add("InstanceArn", instanceArn()).add("DeviceMinutes", deviceMinutes())
                .add("VideoEndpoint", videoEndpoint()).add("VideoCapture", videoCapture()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "started":
            return Optional.ofNullable(clazz.cast(started()));
        case "stopped":
            return Optional.ofNullable(clazz.cast(stopped()));
        case "counters":
            return Optional.ofNullable(clazz.cast(counters()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "device":
            return Optional.ofNullable(clazz.cast(device()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "deviceMinutes":
            return Optional.ofNullable(clazz.cast(deviceMinutes()));
        case "videoEndpoint":
            return Optional.ofNullable(clazz.cast(videoEndpoint()));
        case "videoCapture":
            return Optional.ofNullable(clazz.cast(videoCapture()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Job> {
        /**
         * <p>
         * The job's ARN.
         * </p>
         * 
         * @param arn
         *        The job's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The job's name.
         * </p>
         * 
         * @param name
         *        The job's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The job's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         *        capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(String type);

        /**
         * <p>
         * The job's type.
         * </p>
         * <p>
         * Allowed values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * BUILTIN_FUZZ
         * </p>
         * </li>
         * <li>
         * <p>
         * BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         * capturing screenshots at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_JUNIT
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_JAVA_TESTNG
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_PYTHON
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_NODE
         * </p>
         * </li>
         * <li>
         * <p>
         * APPIUM_WEB_RUBY
         * </p>
         * </li>
         * <li>
         * <p>
         * CALABASH
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTRUMENTATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATION
         * </p>
         * </li>
         * <li>
         * <p>
         * UIAUTOMATOR
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST
         * </p>
         * </li>
         * <li>
         * <p>
         * XCTEST_UI
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The job's type.</p>
         *        <p>
         *        Allowed values include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        BUILTIN_FUZZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and
         *        capturing screenshots at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_JUNIT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_JAVA_TESTNG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_PYTHON
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_NODE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        APPIUM_WEB_RUBY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CALABASH
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTRUMENTATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UIAUTOMATOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        XCTEST_UI
         *        </p>
         *        </li>
         * @see TestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestType
         */
        Builder type(TestType type);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param created
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The job's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The job's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_CONCURRENCY
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING_DEVICE
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING
         * </p>
         * </li>
         * <li>
         * <p>
         * SCHEDULING
         * </p>
         * </li>
         * <li>
         * <p>
         * PREPARING
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPING
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The job's status.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_CONCURRENCY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING_DEVICE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCHEDULING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PREPARING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPING
         *        </p>
         *        </li>
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The job's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The job's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(String result);

        /**
         * <p>
         * The job's result.
         * </p>
         * <p>
         * Allowed values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PENDING
         * </p>
         * </li>
         * <li>
         * <p>
         * PASSED
         * </p>
         * </li>
         * <li>
         * <p>
         * WARNED
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED
         * </p>
         * </li>
         * <li>
         * <p>
         * ERRORED
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED
         * </p>
         * </li>
         * </ul>
         * 
         * @param result
         *        The job's result.</p>
         *        <p>
         *        Allowed values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PENDING
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PASSED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        WARNED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ERRORED
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED
         *        </p>
         *        </li>
         * @see ExecutionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionResult
         */
        Builder result(ExecutionResult result);

        /**
         * <p>
         * The job's start time.
         * </p>
         * 
         * @param started
         *        The job's start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder started(Instant started);

        /**
         * <p>
         * The job's stop time.
         * </p>
         * 
         * @param stopped
         *        The job's stop time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Instant stopped);

        /**
         * <p>
         * The job's result counters.
         * </p>
         * 
         * @param counters
         *        The job's result counters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder counters(Counters counters);

        /**
         * <p>
         * The job's result counters.
         * </p>
         * This is a convenience method that creates an instance of the {@link Counters.Builder} avoiding the need to
         * create one manually via {@link Counters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Counters.Builder#build()} is called immediately and its result is
         * passed to {@link #counters(Counters)}.
         * 
         * @param counters
         *        a consumer that will call methods on {@link Counters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #counters(Counters)
         */
        default Builder counters(Consumer<Counters.Builder> counters) {
            return counters(Counters.builder().applyMutation(counters).build());
        }

        /**
         * <p>
         * A message about the job's result.
         * </p>
         * 
         * @param message
         *        A message about the job's result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The device (phone or tablet).
         * </p>
         * 
         * @param device
         *        The device (phone or tablet).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(Device device);

        /**
         * <p>
         * The device (phone or tablet).
         * </p>
         * This is a convenience method that creates an instance of the {@link Device.Builder} avoiding the need to
         * create one manually via {@link Device#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Device.Builder#build()} is called immediately and its result is
         * passed to {@link #device(Device)}.
         * 
         * @param device
         *        a consumer that will call methods on {@link Device.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #device(Device)
         */
        default Builder device(Consumer<Device.Builder> device) {
            return device(Device.builder().applyMutation(device).build());
        }

        /**
         * <p>
         * The ARN of the instance.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the job.
         * </p>
         * 
         * @param deviceMinutes
         *        Represents the total (metered or unmetered) minutes used by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMinutes(DeviceMinutes deviceMinutes);

        /**
         * <p>
         * Represents the total (metered or unmetered) minutes used by the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceMinutes.Builder} avoiding the need
         * to create one manually via {@link DeviceMinutes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceMinutes.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceMinutes(DeviceMinutes)}.
         * 
         * @param deviceMinutes
         *        a consumer that will call methods on {@link DeviceMinutes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMinutes(DeviceMinutes)
         */
        default Builder deviceMinutes(Consumer<DeviceMinutes.Builder> deviceMinutes) {
            return deviceMinutes(DeviceMinutes.builder().applyMutation(deviceMinutes).build());
        }

        /**
         * <p>
         * The endpoint for streaming device video.
         * </p>
         * 
         * @param videoEndpoint
         *        The endpoint for streaming device video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoEndpoint(String videoEndpoint);

        /**
         * <p>
         * This value is set to true if video capture is enabled. Otherwise, it is set to false.
         * </p>
         * 
         * @param videoCapture
         *        This value is set to true if video capture is enabled. Otherwise, it is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoCapture(Boolean videoCapture);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String type;

        private Instant created;

        private String status;

        private String result;

        private Instant started;

        private Instant stopped;

        private Counters counters;

        private String message;

        private Device device;

        private String instanceArn;

        private DeviceMinutes deviceMinutes;

        private String videoEndpoint;

        private Boolean videoCapture;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            arn(model.arn);
            name(model.name);
            type(model.type);
            created(model.created);
            status(model.status);
            result(model.result);
            started(model.started);
            stopped(model.stopped);
            counters(model.counters);
            message(model.message);
            device(model.device);
            instanceArn(model.instanceArn);
            deviceMinutes(model.deviceMinutes);
            videoEndpoint(model.videoEndpoint);
            videoCapture(model.videoCapture);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(ExecutionResult result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final Instant getStarted() {
            return started;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final Instant getStopped() {
            return stopped;
        }

        public final void setStopped(Instant stopped) {
            this.stopped = stopped;
        }

        @Override
        public final Builder stopped(Instant stopped) {
            this.stopped = stopped;
            return this;
        }

        public final Counters.Builder getCounters() {
            return counters != null ? counters.toBuilder() : null;
        }

        public final void setCounters(Counters.BuilderImpl counters) {
            this.counters = counters != null ? counters.build() : null;
        }

        @Override
        public final Builder counters(Counters counters) {
            this.counters = counters;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Device.Builder getDevice() {
            return device != null ? device.toBuilder() : null;
        }

        public final void setDevice(Device.BuilderImpl device) {
            this.device = device != null ? device.build() : null;
        }

        @Override
        public final Builder device(Device device) {
            this.device = device;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final DeviceMinutes.Builder getDeviceMinutes() {
            return deviceMinutes != null ? deviceMinutes.toBuilder() : null;
        }

        public final void setDeviceMinutes(DeviceMinutes.BuilderImpl deviceMinutes) {
            this.deviceMinutes = deviceMinutes != null ? deviceMinutes.build() : null;
        }

        @Override
        public final Builder deviceMinutes(DeviceMinutes deviceMinutes) {
            this.deviceMinutes = deviceMinutes;
            return this;
        }

        public final String getVideoEndpoint() {
            return videoEndpoint;
        }

        public final void setVideoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
        }

        @Override
        public final Builder videoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
            return this;
        }

        public final Boolean getVideoCapture() {
            return videoCapture;
        }

        public final void setVideoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
        }

        @Override
        public final Builder videoCapture(Boolean videoCapture) {
            this.videoCapture = videoCapture;
            return this;
        }

        @Override
        public Job build() {
            return new Job(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
