/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkProfileType {
    CURATED("CURATED"),
    PRIVATE("PRIVATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkProfileType> VALUE_MAP;
    private final String value;

    private NetworkProfileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkProfileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkProfileType> knownValues() {
        EnumSet<NetworkProfileType> knownValues = EnumSet.allOf(NetworkProfileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkProfileType.class, NetworkProfileType::toString);
    }
}

