/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Suite;
import software.amazon.awssdk.services.devicefarm.model.SuitesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuitesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListSuitesResponse> {
    private static final SdkField<List<Suite>> SUITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suites").getter(ListSuitesResponse.getter(ListSuitesResponse::suites)).setter(ListSuitesResponse.setter(Builder::suites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Suite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSuitesResponse.getter(ListSuitesResponse::nextToken)).setter(ListSuitesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Suite> suites;
    private final String nextToken;

    private ListSuitesResponse(BuilderImpl builder) {
        super(builder);
        this.suites = builder.suites;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSuites() {
        return this.suites != null && !(this.suites instanceof SdkAutoConstructList);
    }

    public final List<Suite> suites() {
        return this.suites;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuites() ? this.suites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuitesResponse)) {
            return false;
        }
        ListSuitesResponse other = (ListSuitesResponse)((Object)obj);
        return this.hasSuites() == other.hasSuites() && Objects.equals(this.suites(), other.suites()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSuitesResponse").add("Suites", this.hasSuites() ? this.suites() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suites": {
                return Optional.ofNullable(clazz.cast(this.suites()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuitesResponse, T> g) {
        return obj -> g.apply((ListSuitesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Suite> suites = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuitesResponse model) {
            super(model);
            this.suites(model.suites);
            this.nextToken(model.nextToken);
        }

        public final List<Suite.Builder> getSuites() {
            List<Suite.Builder> result = SuitesCopier.copyToBuilder(this.suites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuites(Collection<Suite.BuilderImpl> suites) {
            this.suites = SuitesCopier.copyFromBuilder(suites);
        }

        @Override
        public final Builder suites(Collection<Suite> suites) {
            this.suites = SuitesCopier.copy(suites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Suite ... suites) {
            this.suites(Arrays.asList(suites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suites(Consumer<Suite.Builder> ... suites) {
            this.suites(Stream.of(suites).map(c -> (Suite)((Suite.Builder)Suite.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSuitesResponse build() {
            return new ListSuitesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuitesResponse> {
        public Builder suites(Collection<Suite> var1);

        public Builder suites(Suite ... var1);

        public Builder suites(Consumer<Suite.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

