/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactCategory {
    SCREENSHOT("SCREENSHOT"),
    FILE("FILE"),
    LOG("LOG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactCategory> VALUE_MAP;
    private final String value;

    private ArtifactCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactCategory> knownValues() {
        EnumSet<ArtifactCategory> knownValues = EnumSet.allOf(ArtifactCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactCategory.class, ArtifactCategory::toString);
    }
}

