/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionConfiguration;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.InteractionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRemoteAccessSessionRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::projectArn)).setter(CreateRemoteAccessSessionRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceArn").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::deviceArn)).setter(CreateRemoteAccessSessionRequest.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::instanceArn)).setter(CreateRemoteAccessSessionRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sshPublicKey").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::sshPublicKey)).setter(CreateRemoteAccessSessionRequest.setter(Builder::sshPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKey").build()}).build();
    private static final SdkField<Boolean> REMOTE_DEBUG_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteDebugEnabled").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::remoteDebugEnabled)).setter(CreateRemoteAccessSessionRequest.setter(Builder::remoteDebugEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteDebugEnabled").build()}).build();
    private static final SdkField<Boolean> REMOTE_RECORD_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("remoteRecordEnabled").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::remoteRecordEnabled)).setter(CreateRemoteAccessSessionRequest.setter(Builder::remoteRecordEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordEnabled").build()}).build();
    private static final SdkField<String> REMOTE_RECORD_APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteRecordAppArn").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::remoteRecordAppArn)).setter(CreateRemoteAccessSessionRequest.setter(Builder::remoteRecordAppArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteRecordAppArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::name)).setter(CreateRemoteAccessSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::clientId)).setter(CreateRemoteAccessSessionRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<CreateRemoteAccessSessionConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::configuration)).setter(CreateRemoteAccessSessionRequest.setter(Builder::configuration)).constructor(CreateRemoteAccessSessionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> INTERACTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interactionMode").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::interactionModeAsString)).setter(CreateRemoteAccessSessionRequest.setter(Builder::interactionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactionMode").build()}).build();
    private static final SdkField<Boolean> SKIP_APP_RESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipAppResign").getter(CreateRemoteAccessSessionRequest.getter(CreateRemoteAccessSessionRequest::skipAppResign)).setter(CreateRemoteAccessSessionRequest.setter(Builder::skipAppResign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skipAppResign").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, DEVICE_ARN_FIELD, INSTANCE_ARN_FIELD, SSH_PUBLIC_KEY_FIELD, REMOTE_DEBUG_ENABLED_FIELD, REMOTE_RECORD_ENABLED_FIELD, REMOTE_RECORD_APP_ARN_FIELD, NAME_FIELD, CLIENT_ID_FIELD, CONFIGURATION_FIELD, INTERACTION_MODE_FIELD, SKIP_APP_RESIGN_FIELD));
    private final String projectArn;
    private final String deviceArn;
    private final String instanceArn;
    private final String sshPublicKey;
    private final Boolean remoteDebugEnabled;
    private final Boolean remoteRecordEnabled;
    private final String remoteRecordAppArn;
    private final String name;
    private final String clientId;
    private final CreateRemoteAccessSessionConfiguration configuration;
    private final String interactionMode;
    private final Boolean skipAppResign;

    private CreateRemoteAccessSessionRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.deviceArn = builder.deviceArn;
        this.instanceArn = builder.instanceArn;
        this.sshPublicKey = builder.sshPublicKey;
        this.remoteDebugEnabled = builder.remoteDebugEnabled;
        this.remoteRecordEnabled = builder.remoteRecordEnabled;
        this.remoteRecordAppArn = builder.remoteRecordAppArn;
        this.name = builder.name;
        this.clientId = builder.clientId;
        this.configuration = builder.configuration;
        this.interactionMode = builder.interactionMode;
        this.skipAppResign = builder.skipAppResign;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String deviceArn() {
        return this.deviceArn;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String sshPublicKey() {
        return this.sshPublicKey;
    }

    public final Boolean remoteDebugEnabled() {
        return this.remoteDebugEnabled;
    }

    public final Boolean remoteRecordEnabled() {
        return this.remoteRecordEnabled;
    }

    public final String remoteRecordAppArn() {
        return this.remoteRecordAppArn;
    }

    public final String name() {
        return this.name;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final CreateRemoteAccessSessionConfiguration configuration() {
        return this.configuration;
    }

    public final InteractionMode interactionMode() {
        return InteractionMode.fromValue(this.interactionMode);
    }

    public final String interactionModeAsString() {
        return this.interactionMode;
    }

    public final Boolean skipAppResign() {
        return this.skipAppResign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteRecordEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteRecordAppArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipAppResign());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRemoteAccessSessionRequest)) {
            return false;
        }
        CreateRemoteAccessSessionRequest other = (CreateRemoteAccessSessionRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.sshPublicKey(), other.sshPublicKey()) && Objects.equals(this.remoteDebugEnabled(), other.remoteDebugEnabled()) && Objects.equals(this.remoteRecordEnabled(), other.remoteRecordEnabled()) && Objects.equals(this.remoteRecordAppArn(), other.remoteRecordAppArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.interactionModeAsString(), other.interactionModeAsString()) && Objects.equals(this.skipAppResign(), other.skipAppResign());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRemoteAccessSessionRequest").add("ProjectArn", (Object)this.projectArn()).add("DeviceArn", (Object)this.deviceArn()).add("InstanceArn", (Object)this.instanceArn()).add("SshPublicKey", (Object)this.sshPublicKey()).add("RemoteDebugEnabled", (Object)this.remoteDebugEnabled()).add("RemoteRecordEnabled", (Object)this.remoteRecordEnabled()).add("RemoteRecordAppArn", (Object)this.remoteRecordAppArn()).add("Name", (Object)this.name()).add("ClientId", (Object)this.clientId()).add("Configuration", (Object)this.configuration()).add("InteractionMode", (Object)this.interactionModeAsString()).add("SkipAppResign", (Object)this.skipAppResign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "deviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "sshPublicKey": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKey()));
            }
            case "remoteDebugEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugEnabled()));
            }
            case "remoteRecordEnabled": {
                return Optional.ofNullable(clazz.cast(this.remoteRecordEnabled()));
            }
            case "remoteRecordAppArn": {
                return Optional.ofNullable(clazz.cast(this.remoteRecordAppArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "interactionMode": {
                return Optional.ofNullable(clazz.cast(this.interactionModeAsString()));
            }
            case "skipAppResign": {
                return Optional.ofNullable(clazz.cast(this.skipAppResign()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRemoteAccessSessionRequest, T> g) {
        return obj -> g.apply((CreateRemoteAccessSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String deviceArn;
        private String instanceArn;
        private String sshPublicKey;
        private Boolean remoteDebugEnabled;
        private Boolean remoteRecordEnabled;
        private String remoteRecordAppArn;
        private String name;
        private String clientId;
        private CreateRemoteAccessSessionConfiguration configuration;
        private String interactionMode;
        private Boolean skipAppResign;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRemoteAccessSessionRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.deviceArn(model.deviceArn);
            this.instanceArn(model.instanceArn);
            this.sshPublicKey(model.sshPublicKey);
            this.remoteDebugEnabled(model.remoteDebugEnabled);
            this.remoteRecordEnabled(model.remoteRecordEnabled);
            this.remoteRecordAppArn(model.remoteRecordAppArn);
            this.name(model.name);
            this.clientId(model.clientId);
            this.configuration(model.configuration);
            this.interactionMode(model.interactionMode);
            this.skipAppResign(model.skipAppResign);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        @Override
        @Transient
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        @Transient
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        @Transient
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getSshPublicKey() {
            return this.sshPublicKey;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        @Transient
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final Boolean getRemoteDebugEnabled() {
            return this.remoteDebugEnabled;
        }

        public final void setRemoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
        }

        @Override
        @Transient
        public final Builder remoteDebugEnabled(Boolean remoteDebugEnabled) {
            this.remoteDebugEnabled = remoteDebugEnabled;
            return this;
        }

        public final Boolean getRemoteRecordEnabled() {
            return this.remoteRecordEnabled;
        }

        public final void setRemoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
        }

        @Override
        @Transient
        public final Builder remoteRecordEnabled(Boolean remoteRecordEnabled) {
            this.remoteRecordEnabled = remoteRecordEnabled;
            return this;
        }

        public final String getRemoteRecordAppArn() {
            return this.remoteRecordAppArn;
        }

        public final void setRemoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
        }

        @Override
        @Transient
        public final Builder remoteRecordAppArn(String remoteRecordAppArn) {
            this.remoteRecordAppArn = remoteRecordAppArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final CreateRemoteAccessSessionConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(CreateRemoteAccessSessionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(CreateRemoteAccessSessionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getInteractionMode() {
            return this.interactionMode;
        }

        public final void setInteractionMode(String interactionMode) {
            this.interactionMode = interactionMode;
        }

        @Override
        @Transient
        public final Builder interactionMode(String interactionMode) {
            this.interactionMode = interactionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder interactionMode(InteractionMode interactionMode) {
            this.interactionMode(interactionMode == null ? null : interactionMode.toString());
            return this;
        }

        public final Boolean getSkipAppResign() {
            return this.skipAppResign;
        }

        public final void setSkipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
        }

        @Override
        @Transient
        public final Builder skipAppResign(Boolean skipAppResign) {
            this.skipAppResign = skipAppResign;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRemoteAccessSessionRequest build() {
            return new CreateRemoteAccessSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRemoteAccessSessionRequest> {
        public Builder projectArn(String var1);

        public Builder deviceArn(String var1);

        public Builder instanceArn(String var1);

        public Builder sshPublicKey(String var1);

        public Builder remoteDebugEnabled(Boolean var1);

        public Builder remoteRecordEnabled(Boolean var1);

        public Builder remoteRecordAppArn(String var1);

        public Builder name(String var1);

        public Builder clientId(String var1);

        public Builder configuration(CreateRemoteAccessSessionConfiguration var1);

        default public Builder configuration(Consumer<CreateRemoteAccessSessionConfiguration.Builder> configuration) {
            return this.configuration((CreateRemoteAccessSessionConfiguration)((CreateRemoteAccessSessionConfiguration.Builder)CreateRemoteAccessSessionConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder interactionMode(String var1);

        public Builder interactionMode(InteractionMode var1);

        public Builder skipAppResign(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

