/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExecutionResult {
    PENDING("PENDING"),
    PASSED("PASSED"),
    WARNED("WARNED"),
    FAILED("FAILED"),
    SKIPPED("SKIPPED"),
    ERRORED("ERRORED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExecutionResult(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExecutionResult fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExecutionResult.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExecutionResult> knownValues() {
        return Stream.of(ExecutionResult.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

