/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.Offering;
import software.amazon.awssdk.services.devicefarm.model.OfferingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOfferingsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListOfferingsResponse> {
    private static final SdkField<List<Offering>> OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("offerings").getter(ListOfferingsResponse.getter(ListOfferingsResponse::offerings)).setter(ListOfferingsResponse.setter(Builder::offerings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Offering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOfferingsResponse.getter(ListOfferingsResponse::nextToken)).setter(ListOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERINGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Offering> offerings;
    private final String nextToken;

    private ListOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.offerings = builder.offerings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOfferings() {
        return this.offerings != null && !(this.offerings instanceof SdkAutoConstructList);
    }

    public final List<Offering> offerings() {
        return this.offerings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOfferings() ? this.offerings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingsResponse)) {
            return false;
        }
        ListOfferingsResponse other = (ListOfferingsResponse)((Object)obj);
        return this.hasOfferings() == other.hasOfferings() && Objects.equals(this.offerings(), other.offerings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOfferingsResponse").add("Offerings", this.hasOfferings() ? this.offerings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offerings": {
                return Optional.ofNullable(clazz.cast(this.offerings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingsResponse, T> g) {
        return obj -> g.apply((ListOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<Offering> offerings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingsResponse model) {
            super(model);
            this.offerings(model.offerings);
            this.nextToken(model.nextToken);
        }

        public final List<Offering.Builder> getOfferings() {
            List<Offering.Builder> result = OfferingsCopier.copyToBuilder(this.offerings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder offerings(Collection<Offering> offerings) {
            this.offerings = OfferingsCopier.copy(offerings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Offering ... offerings) {
            this.offerings(Arrays.asList(offerings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offerings(Consumer<Offering.Builder> ... offerings) {
            this.offerings(Stream.of(offerings).map(c -> (Offering)((Offering.Builder)Offering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOfferings(Collection<Offering.BuilderImpl> offerings) {
            this.offerings = OfferingsCopier.copyFromBuilder(offerings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingsResponse build() {
            return new ListOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOfferingsResponse> {
        public Builder offerings(Collection<Offering> var1);

        public Builder offerings(Offering ... var1);

        public Builder offerings(Consumer<Offering.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

