/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransaction;
import software.amazon.awssdk.services.devicefarm.model.OfferingTransactionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOfferingTransactionsResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListOfferingTransactionsResponse> {
    private static final SdkField<List<OfferingTransaction>> OFFERING_TRANSACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("offeringTransactions").getter(ListOfferingTransactionsResponse.getter(ListOfferingTransactionsResponse::offeringTransactions)).setter(ListOfferingTransactionsResponse.setter(Builder::offeringTransactions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringTransactions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OfferingTransaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOfferingTransactionsResponse.getter(ListOfferingTransactionsResponse::nextToken)).setter(ListOfferingTransactionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_TRANSACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<OfferingTransaction> offeringTransactions;
    private final String nextToken;

    private ListOfferingTransactionsResponse(BuilderImpl builder) {
        super(builder);
        this.offeringTransactions = builder.offeringTransactions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOfferingTransactions() {
        return this.offeringTransactions != null && !(this.offeringTransactions instanceof SdkAutoConstructList);
    }

    public final List<OfferingTransaction> offeringTransactions() {
        return this.offeringTransactions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOfferingTransactions() ? this.offeringTransactions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOfferingTransactionsResponse)) {
            return false;
        }
        ListOfferingTransactionsResponse other = (ListOfferingTransactionsResponse)((Object)obj);
        return this.hasOfferingTransactions() == other.hasOfferingTransactions() && Objects.equals(this.offeringTransactions(), other.offeringTransactions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOfferingTransactionsResponse").add("OfferingTransactions", this.hasOfferingTransactions() ? this.offeringTransactions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringTransactions": {
                return Optional.ofNullable(clazz.cast(this.offeringTransactions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOfferingTransactionsResponse, T> g) {
        return obj -> g.apply((ListOfferingTransactionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<OfferingTransaction> offeringTransactions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOfferingTransactionsResponse model) {
            super(model);
            this.offeringTransactions(model.offeringTransactions);
            this.nextToken(model.nextToken);
        }

        public final List<OfferingTransaction.Builder> getOfferingTransactions() {
            List<OfferingTransaction.Builder> result = OfferingTransactionsCopier.copyToBuilder(this.offeringTransactions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder offeringTransactions(Collection<OfferingTransaction> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copy(offeringTransactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(OfferingTransaction ... offeringTransactions) {
            this.offeringTransactions(Arrays.asList(offeringTransactions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringTransactions(Consumer<OfferingTransaction.Builder> ... offeringTransactions) {
            this.offeringTransactions(Stream.of(offeringTransactions).map(c -> (OfferingTransaction)((OfferingTransaction.Builder)OfferingTransaction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOfferingTransactions(Collection<OfferingTransaction.BuilderImpl> offeringTransactions) {
            this.offeringTransactions = OfferingTransactionsCopier.copyFromBuilder(offeringTransactions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOfferingTransactionsResponse build() {
            return new ListOfferingTransactionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOfferingTransactionsResponse> {
        public Builder offeringTransactions(Collection<OfferingTransaction> var1);

        public Builder offeringTransactions(OfferingTransaction ... var1);

        public Builder offeringTransactions(Consumer<OfferingTransaction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

