/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestGridSessionAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestGridSessionAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(TestGridSessionAction.getter(TestGridSessionAction::action)).setter(TestGridSessionAction.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Instant> STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("started").getter(TestGridSessionAction.getter(TestGridSessionAction::started)).setter(TestGridSessionAction.setter(Builder::started)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("started").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("duration").getter(TestGridSessionAction.getter(TestGridSessionAction::duration)).setter(TestGridSessionAction.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(TestGridSessionAction.getter(TestGridSessionAction::statusCode)).setter(TestGridSessionAction.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> REQUEST_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestMethod").getter(TestGridSessionAction.getter(TestGridSessionAction::requestMethod)).setter(TestGridSessionAction.setter(Builder::requestMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, STARTED_FIELD, DURATION_FIELD, STATUS_CODE_FIELD, REQUEST_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final Instant started;
    private final Long duration;
    private final String statusCodeValue;
    private final String requestMethod;

    private TestGridSessionAction(BuilderImpl builder) {
        this.action = builder.action;
        this.started = builder.started;
        this.duration = builder.duration;
        this.statusCodeValue = builder.statusCodeValue;
        this.requestMethod = builder.requestMethod;
    }

    public final String action() {
        return this.action;
    }

    public final Instant started() {
        return this.started;
    }

    public final Long duration() {
        return this.duration;
    }

    public final String statusCode() {
        return this.statusCodeValue;
    }

    public final String requestMethod() {
        return this.requestMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.started());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMethod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestGridSessionAction)) {
            return false;
        }
        TestGridSessionAction other = (TestGridSessionAction)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.started(), other.started()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.requestMethod(), other.requestMethod());
    }

    public final String toString() {
        return ToString.builder((String)"TestGridSessionAction").add("Action", (Object)this.action()).add("Started", (Object)this.started()).add("Duration", (Object)this.duration()).add("StatusCode", (Object)this.statusCode()).add("RequestMethod", (Object)this.requestMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "started": {
                return Optional.ofNullable(clazz.cast(this.started()));
            }
            case "duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "requestMethod": {
                return Optional.ofNullable(clazz.cast(this.requestMethod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestGridSessionAction, T> g) {
        return obj -> g.apply((TestGridSessionAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Instant started;
        private Long duration;
        private String statusCodeValue;
        private String requestMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(TestGridSessionAction model) {
            this.action(model.action);
            this.started(model.started);
            this.duration(model.duration);
            this.statusCode(model.statusCodeValue);
            this.requestMethod(model.requestMethod);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Instant getStarted() {
            return this.started;
        }

        @Override
        public final Builder started(Instant started) {
            this.started = started;
            return this;
        }

        public final void setStarted(Instant started) {
            this.started = started;
        }

        public final Long getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        public final String getRequestMethod() {
            return this.requestMethod;
        }

        @Override
        public final Builder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public final void setRequestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
        }

        public TestGridSessionAction build() {
            return new TestGridSessionAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestGridSessionAction> {
        public Builder action(String var1);

        public Builder started(Instant var1);

        public Builder duration(Long var1);

        public Builder statusCode(String var1);

        public Builder requestMethod(String var1);
    }
}

