/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DevicePlatform {
    ANDROID("ANDROID"),
    IOS("IOS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DevicePlatform(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DevicePlatform fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DevicePlatform.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DevicePlatform> knownValues() {
        return Stream.of(DevicePlatform.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

