/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.Rule;
import software.amazon.awssdk.services.devicefarm.model.RulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDevicePoolRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateDevicePoolRequest> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectArn").getter(CreateDevicePoolRequest.getter(CreateDevicePoolRequest::projectArn)).setter(CreateDevicePoolRequest.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDevicePoolRequest.getter(CreateDevicePoolRequest::name)).setter(CreateDevicePoolRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDevicePoolRequest.getter(CreateDevicePoolRequest::description)).setter(CreateDevicePoolRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(CreateDevicePoolRequest.getter(CreateDevicePoolRequest::rules)).setter(CreateDevicePoolRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDevices").getter(CreateDevicePoolRequest.getter(CreateDevicePoolRequest::maxDevices)).setter(CreateDevicePoolRequest.setter(Builder::maxDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDevices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, RULES_FIELD, MAX_DEVICES_FIELD));
    private final String projectArn;
    private final String name;
    private final String description;
    private final List<Rule> rules;
    private final Integer maxDevices;

    private CreateDevicePoolRequest(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
        this.maxDevices = builder.maxDevices;
    }

    public String projectArn() {
        return this.projectArn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<Rule> rules() {
        return this.rules;
    }

    public Integer maxDevices() {
        return this.maxDevices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDevices());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDevicePoolRequest)) {
            return false;
        }
        CreateDevicePoolRequest other = (CreateDevicePoolRequest)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.maxDevices(), other.maxDevices());
    }

    public String toString() {
        return ToString.builder((String)"CreateDevicePoolRequest").add("ProjectArn", (Object)this.projectArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Rules", this.rules()).add("MaxDevices", (Object)this.maxDevices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "maxDevices": {
                return Optional.ofNullable(clazz.cast(this.maxDevices()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDevicePoolRequest, T> g) {
        return obj -> g.apply((CreateDevicePoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String projectArn;
        private String name;
        private String description;
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private Integer maxDevices;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDevicePoolRequest model) {
            super(model);
            this.projectArn(model.projectArn);
            this.name(model.name);
            this.description(model.description);
            this.rules(model.rules);
            this.maxDevices(model.maxDevices);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Rule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(Rule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RulesCopier.copyFromBuilder(rules);
        }

        public final Integer getMaxDevices() {
            return this.maxDevices;
        }

        @Override
        public final Builder maxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
            return this;
        }

        public final void setMaxDevices(Integer maxDevices) {
            this.maxDevices = maxDevices;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDevicePoolRequest build() {
            return new CreateDevicePoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDevicePoolRequest> {
        public Builder projectArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder maxDevices(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

