/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse;

public class ListTestGridSessionArtifactsIterable
implements SdkIterable<ListTestGridSessionArtifactsResponse> {
    private final DeviceFarmClient client;
    private final ListTestGridSessionArtifactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestGridSessionArtifactsIterable(DeviceFarmClient client, ListTestGridSessionArtifactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestGridSessionArtifactsResponseFetcher();
    }

    public Iterator<ListTestGridSessionArtifactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestGridSessionArtifactsResponseFetcher
    implements SyncPageFetcher<ListTestGridSessionArtifactsResponse> {
        private ListTestGridSessionArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridSessionArtifactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestGridSessionArtifactsResponse nextPage(ListTestGridSessionArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridSessionArtifactsIterable.this.client.listTestGridSessionArtifacts(ListTestGridSessionArtifactsIterable.this.firstRequest);
            }
            return ListTestGridSessionArtifactsIterable.this.client.listTestGridSessionArtifacts((ListTestGridSessionArtifactsRequest)((Object)ListTestGridSessionArtifactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

