/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusRequest;
import software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;

public class GetOfferingStatusPublisher
implements SdkPublisher<GetOfferingStatusResponse> {
    private final DeviceFarmAsyncClient client;
    private final GetOfferingStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOfferingStatusPublisher(DeviceFarmAsyncClient client, GetOfferingStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOfferingStatusPublisher(DeviceFarmAsyncClient client, GetOfferingStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOfferingStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOfferingStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map.Entry<String, OfferingStatus>> current() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.current() != null) {
                return response.current().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOfferingStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<Map.Entry<String, OfferingStatus>> nextPeriod() {
        Function<GetOfferingStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.nextPeriod() != null) {
                return response.nextPeriod().entrySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOfferingStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final GetOfferingStatusPublisher resume(GetOfferingStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetOfferingStatusPublisher(this.client, (GetOfferingStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetOfferingStatusPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetOfferingStatusResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetOfferingStatusResponseFetcher
    implements AsyncPageFetcher<GetOfferingStatusResponse> {
        private GetOfferingStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetOfferingStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOfferingStatusResponse> nextPage(GetOfferingStatusResponse previousPage) {
            if (previousPage == null) {
                return GetOfferingStatusPublisher.this.client.getOfferingStatus(GetOfferingStatusPublisher.this.firstRequest);
            }
            return GetOfferingStatusPublisher.this.client.getOfferingStatus((GetOfferingStatusRequest)((Object)GetOfferingStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

