/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.Suite;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SuiteMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("created").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> RESULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("result").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("started").isBinary(false).build();
    private static final MarshallingInfo<Instant> STOPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopped").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COUNTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("counters").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICEMINUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceMinutes").isBinary(false).build();
    private static final SuiteMarshaller INSTANCE = new SuiteMarshaller();

    private SuiteMarshaller() {
    }

    public static SuiteMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Suite suite, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)suite, (String)"suite");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)suite.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)suite.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)suite.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)suite.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)suite.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)suite.resultString(), RESULT_BINDING);
            protocolMarshaller.marshall((Object)suite.started(), STARTED_BINDING);
            protocolMarshaller.marshall((Object)suite.stopped(), STOPPED_BINDING);
            protocolMarshaller.marshall((Object)suite.counters(), COUNTERS_BINDING);
            protocolMarshaller.marshall((Object)suite.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)suite.deviceMinutes(), DEVICEMINUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

