/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.devicefarm.model.OfferingStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OfferingStatusMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OFFERING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offering").isBinary(false).build();
    private static final MarshallingInfo<Integer> QUANTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("quantity").isBinary(false).build();
    private static final MarshallingInfo<Instant> EFFECTIVEON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("effectiveOn").isBinary(false).build();
    private static final OfferingStatusMarshaller INSTANCE = new OfferingStatusMarshaller();

    private OfferingStatusMarshaller() {
    }

    public static OfferingStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OfferingStatus offeringStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)offeringStatus, (String)"offeringStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)offeringStatus.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)offeringStatus.offering(), OFFERING_BINDING);
            protocolMarshaller.marshall((Object)offeringStatus.quantity(), QUANTITY_BINDING);
            protocolMarshaller.marshall((Object)offeringStatus.effectiveOn(), EFFECTIVEON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

