/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.devicefarm.model.MonetaryAmount;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MonetaryAmountMarshaller {
    private static final MarshallingInfo<Double> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amount").isBinary(false).build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currencyCode").isBinary(false).build();
    private static final MonetaryAmountMarshaller INSTANCE = new MonetaryAmountMarshaller();

    private MonetaryAmountMarshaller() {
    }

    public static MonetaryAmountMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MonetaryAmount monetaryAmount, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)monetaryAmount, (String)"monetaryAmount");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)monetaryAmount.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)monetaryAmount.currencyCodeString(), CURRENCYCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

