/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.model.ListRunsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListRunsResponse;
import software.amazon.awssdk.services.devicefarm.model.Run;

public class ListRunsIterable
implements SdkIterable<ListRunsResponse> {
    private final DeviceFarmClient client;
    private final ListRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRunsIterable(DeviceFarmClient client, ListRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRunsResponseFetcher();
    }

    public Iterator<ListRunsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Run> runs() {
        Function<ListRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.runs() != null) {
                return response.runs().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListRunsIterable resume(ListRunsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListRunsIterable(this.client, (ListRunsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListRunsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListRunsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListRunsResponseFetcher
    implements SyncPageFetcher<ListRunsResponse> {
        private ListRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListRunsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListRunsResponse nextPage(ListRunsResponse previousPage) {
            if (previousPage == null) {
                return ListRunsIterable.this.client.listRuns(ListRunsIterable.this.firstRequest);
            }
            return ListRunsIterable.this.client.listRuns((ListRunsRequest)((Object)ListRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

