/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.Artifact;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListArtifactsResponse;

public class ListArtifactsPublisher
implements SdkPublisher<ListArtifactsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListArtifactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArtifactsPublisher(DeviceFarmAsyncClient client, ListArtifactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArtifactsPublisher(DeviceFarmAsyncClient client, ListArtifactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArtifactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArtifactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Artifact> artifacts() {
        Function<ListArtifactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.artifacts() != null) {
                return response.artifacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListArtifactsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListArtifactsPublisher resume(ListArtifactsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListArtifactsPublisher(this.client, (ListArtifactsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListArtifactsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListArtifactsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListArtifactsResponseFetcher
    implements AsyncPageFetcher<ListArtifactsResponse> {
        private ListArtifactsResponseFetcher() {
        }

        public boolean hasNextPage(ListArtifactsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListArtifactsResponse> nextPage(ListArtifactsResponse previousPage) {
            if (previousPage == null) {
                return ListArtifactsPublisher.this.client.listArtifacts(ListArtifactsPublisher.this.firstRequest);
            }
            return ListArtifactsPublisher.this.client.listArtifacts((ListArtifactsRequest)((Object)ListArtifactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

